package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCompatibleKafkaVersionsRequest(
    clusterArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest = {
    import GetCompatibleKafkaVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest.ReadOnly =
    zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest.wrap(buildAwsValue())
}
object GetCompatibleKafkaVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest =
      zio.aws.kafka.model
        .GetCompatibleKafkaVersionsRequest(clusterArn.map(value => value))
    def clusterArn: Optional[__string]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest
  ) extends zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest.ReadOnly {
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest
  ): zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
