package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcConnectivity(
    clientAuthentication: Optional[
      zio.aws.kafka.model.VpcConnectivityClientAuthentication
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.VpcConnectivity = {
    import VpcConnectivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.VpcConnectivity
      .builder()
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.VpcConnectivity.ReadOnly =
    zio.aws.kafka.model.VpcConnectivity.wrap(buildAwsValue())
}
object VpcConnectivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.VpcConnectivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.VpcConnectivity = zio.aws.kafka.model
      .VpcConnectivity(clientAuthentication.map(value => value.asEditable))
    def clientAuthentication: Optional[
      zio.aws.kafka.model.VpcConnectivityClientAuthentication.ReadOnly
    ]
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.VpcConnectivityClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivity
  ) extends zio.aws.kafka.model.VpcConnectivity.ReadOnly {
    override val clientAuthentication: Optional[
      zio.aws.kafka.model.VpcConnectivityClientAuthentication.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clientAuthentication())
      .map(value =>
        zio.aws.kafka.model.VpcConnectivityClientAuthentication.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivity
  ): zio.aws.kafka.model.VpcConnectivity.ReadOnly = new Wrapper(impl)
}
