package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcConnectivityClientAuthentication(
    sasl: Optional[zio.aws.kafka.model.VpcConnectivitySasl] = Optional.Absent,
    tls: Optional[zio.aws.kafka.model.VpcConnectivityTls] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.VpcConnectivityClientAuthentication = {
    import VpcConnectivityClientAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.VpcConnectivityClientAuthentication
      .builder()
      .optionallyWith(sasl.map(value => value.buildAwsValue()))(_.sasl)
      .optionallyWith(tls.map(value => value.buildAwsValue()))(_.tls)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.VpcConnectivityClientAuthentication.ReadOnly =
    zio.aws.kafka.model.VpcConnectivityClientAuthentication
      .wrap(buildAwsValue())
}
object VpcConnectivityClientAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.VpcConnectivityClientAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.VpcConnectivityClientAuthentication =
      zio.aws.kafka.model.VpcConnectivityClientAuthentication(
        sasl.map(value => value.asEditable),
        tls.map(value => value.asEditable)
      )
    def sasl: Optional[zio.aws.kafka.model.VpcConnectivitySasl.ReadOnly]
    def tls: Optional[zio.aws.kafka.model.VpcConnectivityTls.ReadOnly]
    def getSasl
        : ZIO[Any, AwsError, zio.aws.kafka.model.VpcConnectivitySasl.ReadOnly] =
      AwsError.unwrapOptionField("sasl", sasl)
    def getTls
        : ZIO[Any, AwsError, zio.aws.kafka.model.VpcConnectivityTls.ReadOnly] =
      AwsError.unwrapOptionField("tls", tls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivityClientAuthentication
  ) extends zio.aws.kafka.model.VpcConnectivityClientAuthentication.ReadOnly {
    override val sasl
        : Optional[zio.aws.kafka.model.VpcConnectivitySasl.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sasl())
        .map(value => zio.aws.kafka.model.VpcConnectivitySasl.wrap(value))
    override val tls
        : Optional[zio.aws.kafka.model.VpcConnectivityTls.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tls())
        .map(value => zio.aws.kafka.model.VpcConnectivityTls.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectivityClientAuthentication
  ): zio.aws.kafka.model.VpcConnectivityClientAuthentication.ReadOnly =
    new Wrapper(impl)
}
