package zio.aws.kafka.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class VpcConnectionInfo(
    vpcConnectionArn: Optional[__string] = Optional.Absent,
    owner: Optional[__string] = Optional.Absent,
    userIdentity: Optional[zio.aws.kafka.model.UserIdentity] = Optional.Absent,
    creationTime: Optional[__timestampIso8601] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.VpcConnectionInfo = {
    import VpcConnectionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.VpcConnectionInfo
      .builder()
      .optionallyWith(vpcConnectionArn.map(value => value: java.lang.String))(
        _.vpcConnectionArn
      )
      .optionallyWith(owner.map(value => value: java.lang.String))(_.owner)
      .optionallyWith(userIdentity.map(value => value.buildAwsValue()))(
        _.userIdentity
      )
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.VpcConnectionInfo.ReadOnly =
    zio.aws.kafka.model.VpcConnectionInfo.wrap(buildAwsValue())
}
object VpcConnectionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.VpcConnectionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.VpcConnectionInfo =
      zio.aws.kafka.model.VpcConnectionInfo(
        vpcConnectionArn.map(value => value),
        owner.map(value => value),
        userIdentity.map(value => value.asEditable),
        creationTime.map(value => value)
      )
    def vpcConnectionArn: Optional[__string]
    def owner: Optional[__string]
    def userIdentity: Optional[zio.aws.kafka.model.UserIdentity.ReadOnly]
    def creationTime: Optional[__timestampIso8601]
    def getVpcConnectionArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vpcConnectionArn", vpcConnectionArn)
    def getOwner: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("owner", owner)
    def getUserIdentity
        : ZIO[Any, AwsError, zio.aws.kafka.model.UserIdentity.ReadOnly] =
      AwsError.unwrapOptionField("userIdentity", userIdentity)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectionInfo
  ) extends zio.aws.kafka.model.VpcConnectionInfo.ReadOnly {
    override val vpcConnectionArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConnectionArn())
      .map(value => value: __string)
    override val owner: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => value: __string)
    override val userIdentity
        : Optional[zio.aws.kafka.model.UserIdentity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userIdentity())
        .map(value => zio.aws.kafka.model.UserIdentity.wrap(value))
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.VpcConnectionInfo
  ): zio.aws.kafka.model.VpcConnectionInfo.ReadOnly = new Wrapper(impl)
}
