package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RejectClientVpcConnectionRequest(
    clusterArn: Optional[__string] = Optional.Absent,
    vpcConnectionArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.RejectClientVpcConnectionRequest = {
    import RejectClientVpcConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.RejectClientVpcConnectionRequest
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .vpcConnectionArn(vpcConnectionArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.RejectClientVpcConnectionRequest.ReadOnly =
    zio.aws.kafka.model.RejectClientVpcConnectionRequest.wrap(buildAwsValue())
}
object RejectClientVpcConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.RejectClientVpcConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.RejectClientVpcConnectionRequest =
      zio.aws.kafka.model.RejectClientVpcConnectionRequest(
        clusterArn.map(value => value),
        vpcConnectionArn
      )
    def clusterArn: Optional[__string]
    def vpcConnectionArn: __string
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getVpcConnectionArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(vpcConnectionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.RejectClientVpcConnectionRequest
  ) extends zio.aws.kafka.model.RejectClientVpcConnectionRequest.ReadOnly {
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val vpcConnectionArn: __string = impl.vpcConnectionArn(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.RejectClientVpcConnectionRequest
  ): zio.aws.kafka.model.RejectClientVpcConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
