package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserIdentity(
    `type`: Optional[zio.aws.kafka.model.UserIdentityType] = Optional.Absent,
    principalId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UserIdentity = {
    import UserIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UserIdentity
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UserIdentity.ReadOnly =
    zio.aws.kafka.model.UserIdentity.wrap(buildAwsValue())
}
object UserIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UserIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UserIdentity = zio.aws.kafka.model
      .UserIdentity(`type`.map(value => value), principalId.map(value => value))
    def `type`: Optional[zio.aws.kafka.model.UserIdentityType]
    def principalId: Optional[__string]
    def getType: ZIO[Any, AwsError, zio.aws.kafka.model.UserIdentityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPrincipalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("principalId", principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UserIdentity
  ) extends zio.aws.kafka.model.UserIdentity.ReadOnly {
    override val `type`: Optional[zio.aws.kafka.model.UserIdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.kafka.model.UserIdentityType.wrap(value))
    override val principalId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UserIdentity
  ): zio.aws.kafka.model.UserIdentity.ReadOnly = new Wrapper(impl)
}
