package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListClientVpcConnectionsResponse(
    clientVpcConnections: Optional[
      Iterable[zio.aws.kafka.model.ClientVpcConnection]
    ] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse = {
    import ListClientVpcConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse
      .builder()
      .optionallyWith(
        clientVpcConnections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clientVpcConnections)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.ListClientVpcConnectionsResponse.ReadOnly =
    zio.aws.kafka.model.ListClientVpcConnectionsResponse.wrap(buildAwsValue())
}
object ListClientVpcConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClientVpcConnectionsResponse =
      zio.aws.kafka.model.ListClientVpcConnectionsResponse(
        clientVpcConnections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clientVpcConnections
        : Optional[List[zio.aws.kafka.model.ClientVpcConnection.ReadOnly]]
    def nextToken: Optional[__string]
    def getClientVpcConnections: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ClientVpcConnection.ReadOnly
    ]] =
      AwsError.unwrapOptionField("clientVpcConnections", clientVpcConnections)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse
  ) extends zio.aws.kafka.model.ListClientVpcConnectionsResponse.ReadOnly {
    override val clientVpcConnections
        : Optional[List[zio.aws.kafka.model.ClientVpcConnection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientVpcConnections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.ClientVpcConnection.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse
  ): zio.aws.kafka.model.ListClientVpcConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
