package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClusterOperationV2Provisioned(
    operationSteps: Optional[
      Iterable[zio.aws.kafka.model.ClusterOperationStep]
    ] = Optional.Absent,
    sourceClusterInfo: Optional[zio.aws.kafka.model.MutableClusterInfo] =
      Optional.Absent,
    targetClusterInfo: Optional[zio.aws.kafka.model.MutableClusterInfo] =
      Optional.Absent,
    vpcConnectionInfo: Optional[zio.aws.kafka.model.VpcConnectionInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClusterOperationV2Provisioned = {
    import ClusterOperationV2Provisioned.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClusterOperationV2Provisioned
      .builder()
      .optionallyWith(
        operationSteps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operationSteps)
      .optionallyWith(sourceClusterInfo.map(value => value.buildAwsValue()))(
        _.sourceClusterInfo
      )
      .optionallyWith(targetClusterInfo.map(value => value.buildAwsValue()))(
        _.targetClusterInfo
      )
      .optionallyWith(vpcConnectionInfo.map(value => value.buildAwsValue()))(
        _.vpcConnectionInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClusterOperationV2Provisioned.ReadOnly =
    zio.aws.kafka.model.ClusterOperationV2Provisioned.wrap(buildAwsValue())
}
object ClusterOperationV2Provisioned {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ClusterOperationV2Provisioned
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClusterOperationV2Provisioned =
      zio.aws.kafka.model.ClusterOperationV2Provisioned(
        operationSteps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceClusterInfo.map(value => value.asEditable),
        targetClusterInfo.map(value => value.asEditable),
        vpcConnectionInfo.map(value => value.asEditable)
      )
    def operationSteps
        : Optional[List[zio.aws.kafka.model.ClusterOperationStep.ReadOnly]]
    def sourceClusterInfo
        : Optional[zio.aws.kafka.model.MutableClusterInfo.ReadOnly]
    def targetClusterInfo
        : Optional[zio.aws.kafka.model.MutableClusterInfo.ReadOnly]
    def vpcConnectionInfo
        : Optional[zio.aws.kafka.model.VpcConnectionInfo.ReadOnly]
    def getOperationSteps: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ClusterOperationStep.ReadOnly
    ]] = AwsError.unwrapOptionField("operationSteps", operationSteps)
    def getSourceClusterInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.MutableClusterInfo.ReadOnly] =
      AwsError.unwrapOptionField("sourceClusterInfo", sourceClusterInfo)
    def getTargetClusterInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.MutableClusterInfo.ReadOnly] =
      AwsError.unwrapOptionField("targetClusterInfo", targetClusterInfo)
    def getVpcConnectionInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.VpcConnectionInfo.ReadOnly] =
      AwsError.unwrapOptionField("vpcConnectionInfo", vpcConnectionInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationV2Provisioned
  ) extends zio.aws.kafka.model.ClusterOperationV2Provisioned.ReadOnly {
    override val operationSteps
        : Optional[List[zio.aws.kafka.model.ClusterOperationStep.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationSteps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.ClusterOperationStep.wrap(item)
          }.toList
        )
    override val sourceClusterInfo
        : Optional[zio.aws.kafka.model.MutableClusterInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceClusterInfo())
        .map(value => zio.aws.kafka.model.MutableClusterInfo.wrap(value))
    override val targetClusterInfo
        : Optional[zio.aws.kafka.model.MutableClusterInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetClusterInfo())
        .map(value => zio.aws.kafka.model.MutableClusterInfo.wrap(value))
    override val vpcConnectionInfo
        : Optional[zio.aws.kafka.model.VpcConnectionInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConnectionInfo())
        .map(value => zio.aws.kafka.model.VpcConnectionInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationV2Provisioned
  ): zio.aws.kafka.model.ClusterOperationV2Provisioned.ReadOnly = new Wrapper(
    impl
  )
}
