package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutClusterPolicyRequest(
    clusterArn: __string,
    currentVersion: Optional[__string] = Optional.Absent,
    policy: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.PutClusterPolicyRequest = {
    import PutClusterPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.PutClusterPolicyRequest
      .builder()
      .clusterArn(clusterArn: java.lang.String)
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .policy(policy: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.PutClusterPolicyRequest.ReadOnly =
    zio.aws.kafka.model.PutClusterPolicyRequest.wrap(buildAwsValue())
}
object PutClusterPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.PutClusterPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.PutClusterPolicyRequest =
      zio.aws.kafka.model.PutClusterPolicyRequest(
        clusterArn,
        currentVersion.map(value => value),
        policy
      )
    def clusterArn: __string
    def currentVersion: Optional[__string]
    def policy: __string
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getPolicy: ZIO[Any, Nothing, __string] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.PutClusterPolicyRequest
  ) extends zio.aws.kafka.model.PutClusterPolicyRequest.ReadOnly {
    override val clusterArn: __string = impl.clusterArn(): __string
    override val currentVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: __string)
    override val policy: __string = impl.policy(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.PutClusterPolicyRequest
  ): zio.aws.kafka.model.PutClusterPolicyRequest.ReadOnly = new Wrapper(impl)
}
