package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCompatibleKafkaVersionsResponse(
    compatibleKafkaVersions: Optional[
      Iterable[zio.aws.kafka.model.CompatibleKafkaVersion]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsResponse = {
    import GetCompatibleKafkaVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsResponse
      .builder()
      .optionallyWith(
        compatibleKafkaVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.compatibleKafkaVersions)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse.ReadOnly =
    zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse.wrap(buildAwsValue())
}
object GetCompatibleKafkaVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse =
      zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse(
        compatibleKafkaVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def compatibleKafkaVersions
        : Optional[List[zio.aws.kafka.model.CompatibleKafkaVersion.ReadOnly]]
    def getCompatibleKafkaVersions: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.CompatibleKafkaVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "compatibleKafkaVersions",
      compatibleKafkaVersions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsResponse
  ) extends zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse.ReadOnly {
    override val compatibleKafkaVersions
        : Optional[List[zio.aws.kafka.model.CompatibleKafkaVersion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compatibleKafkaVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.CompatibleKafkaVersion.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsResponse
  ): zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
