package zio.aws.kafka.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__integer, __string}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateStorageRequest(
    clusterArn: __string,
    currentVersion: __string,
    provisionedThroughput: Optional[zio.aws.kafka.model.ProvisionedThroughput] =
      Optional.Absent,
    storageMode: Optional[zio.aws.kafka.model.StorageMode] = Optional.Absent,
    volumeSizeGB: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateStorageRequest = {
    import UpdateStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateStorageRequest
      .builder()
      .clusterArn(clusterArn: java.lang.String)
      .currentVersion(currentVersion: java.lang.String)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(storageMode.map(value => value.unwrap))(_.storageMode)
      .optionallyWith(volumeSizeGB.map(value => value: Integer))(_.volumeSizeGB)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateStorageRequest.ReadOnly =
    zio.aws.kafka.model.UpdateStorageRequest.wrap(buildAwsValue())
}
object UpdateStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateStorageRequest =
      zio.aws.kafka.model.UpdateStorageRequest(
        clusterArn,
        currentVersion,
        provisionedThroughput.map(value => value.asEditable),
        storageMode.map(value => value),
        volumeSizeGB.map(value => value)
      )
    def clusterArn: __string
    def currentVersion: __string
    def provisionedThroughput
        : Optional[zio.aws.kafka.model.ProvisionedThroughput.ReadOnly]
    def storageMode: Optional[zio.aws.kafka.model.StorageMode]
    def volumeSizeGB: Optional[__integer]
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getCurrentVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(currentVersion)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getStorageMode: ZIO[Any, AwsError, zio.aws.kafka.model.StorageMode] =
      AwsError.unwrapOptionField("storageMode", storageMode)
    def getVolumeSizeGB: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("volumeSizeGB", volumeSizeGB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateStorageRequest
  ) extends zio.aws.kafka.model.UpdateStorageRequest.ReadOnly {
    override val clusterArn: __string = impl.clusterArn(): __string
    override val currentVersion: __string = impl.currentVersion(): __string
    override val provisionedThroughput
        : Optional[zio.aws.kafka.model.ProvisionedThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedThroughput())
        .map(value => zio.aws.kafka.model.ProvisionedThroughput.wrap(value))
    override val storageMode: Optional[zio.aws.kafka.model.StorageMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageMode())
        .map(value => zio.aws.kafka.model.StorageMode.wrap(value))
    override val volumeSizeGB: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSizeGB())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateStorageRequest
  ): zio.aws.kafka.model.UpdateStorageRequest.ReadOnly = new Wrapper(impl)
}
