package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListClustersV2Response(
    clusterInfoList: Optional[Iterable[zio.aws.kafka.model.Cluster]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClustersV2Response = {
    import ListClustersV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClustersV2Response
      .builder()
      .optionallyWith(
        clusterInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterInfoList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListClustersV2Response.ReadOnly =
    zio.aws.kafka.model.ListClustersV2Response.wrap(buildAwsValue())
}
object ListClustersV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClustersV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClustersV2Response =
      zio.aws.kafka.model.ListClustersV2Response(
        clusterInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clusterInfoList: Optional[List[zio.aws.kafka.model.Cluster.ReadOnly]]
    def nextToken: Optional[__string]
    def getClusterInfoList
        : ZIO[Any, AwsError, List[zio.aws.kafka.model.Cluster.ReadOnly]] =
      AwsError.unwrapOptionField("clusterInfoList", clusterInfoList)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersV2Response
  ) extends zio.aws.kafka.model.ListClustersV2Response.ReadOnly {
    override val clusterInfoList
        : Optional[List[zio.aws.kafka.model.Cluster.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.Cluster.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersV2Response
  ): zio.aws.kafka.model.ListClustersV2Response.ReadOnly = new Wrapper(impl)
}
