package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Tls(
    certificateAuthorityArnList: Optional[Iterable[__string]] = Optional.Absent,
    enabled: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.Tls = {
    import Tls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Tls
      .builder()
      .optionallyWith(
        certificateAuthorityArnList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.certificateAuthorityArnList)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Tls.ReadOnly =
    zio.aws.kafka.model.Tls.wrap(buildAwsValue())
}
object Tls {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.Tls] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Tls = zio.aws.kafka.model.Tls(
      certificateAuthorityArnList.map(value => value),
      enabled.map(value => value)
    )
    def certificateAuthorityArnList: Optional[List[__string]]
    def enabled: Optional[__boolean]
    def getCertificateAuthorityArnList: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "certificateAuthorityArnList",
        certificateAuthorityArnList
      )
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Tls
  ) extends zio.aws.kafka.model.Tls.ReadOnly {
    override val certificateAuthorityArnList: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateAuthorityArnList())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Tls
  ): zio.aws.kafka.model.Tls.ReadOnly = new Wrapper(impl)
}
