package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__stringMin5Max32, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BrokerNodeGroupInfo(
    brokerAZDistribution: Optional[zio.aws.kafka.model.BrokerAZDistribution] =
      Optional.Absent,
    clientSubnets: Iterable[__string],
    instanceType: __stringMin5Max32,
    securityGroups: Optional[Iterable[__string]] = Optional.Absent,
    storageInfo: Optional[zio.aws.kafka.model.StorageInfo] = Optional.Absent,
    connectivityInfo: Optional[zio.aws.kafka.model.ConnectivityInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo = {
    import BrokerNodeGroupInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo
      .builder()
      .optionallyWith(brokerAZDistribution.map(value => value.unwrap))(
        _.brokerAZDistribution
      )
      .clientSubnets(clientSubnets.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .instanceType(instanceType: java.lang.String)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(storageInfo.map(value => value.buildAwsValue()))(
        _.storageInfo
      )
      .optionallyWith(connectivityInfo.map(value => value.buildAwsValue()))(
        _.connectivityInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly =
    zio.aws.kafka.model.BrokerNodeGroupInfo.wrap(buildAwsValue())
}
object BrokerNodeGroupInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BrokerNodeGroupInfo =
      zio.aws.kafka.model.BrokerNodeGroupInfo(
        brokerAZDistribution.map(value => value),
        clientSubnets,
        instanceType,
        securityGroups.map(value => value),
        storageInfo.map(value => value.asEditable),
        connectivityInfo.map(value => value.asEditable)
      )
    def brokerAZDistribution: Optional[zio.aws.kafka.model.BrokerAZDistribution]
    def clientSubnets: List[__string]
    def instanceType: __stringMin5Max32
    def securityGroups: Optional[List[__string]]
    def storageInfo: Optional[zio.aws.kafka.model.StorageInfo.ReadOnly]
    def connectivityInfo
        : Optional[zio.aws.kafka.model.ConnectivityInfo.ReadOnly]
    def getBrokerAZDistribution
        : ZIO[Any, AwsError, zio.aws.kafka.model.BrokerAZDistribution] =
      AwsError.unwrapOptionField("brokerAZDistribution", brokerAZDistribution)
    def getClientSubnets: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(clientSubnets)
    def getInstanceType: ZIO[Any, Nothing, __stringMin5Max32] =
      ZIO.succeed(instanceType)
    def getSecurityGroups: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getStorageInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.StorageInfo.ReadOnly] =
      AwsError.unwrapOptionField("storageInfo", storageInfo)
    def getConnectivityInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ConnectivityInfo.ReadOnly] =
      AwsError.unwrapOptionField("connectivityInfo", connectivityInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo
  ) extends zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly {
    override val brokerAZDistribution
        : Optional[zio.aws.kafka.model.BrokerAZDistribution] =
      zio.aws.core.internal
        .optionalFromNullable(impl.brokerAZDistribution())
        .map(value => zio.aws.kafka.model.BrokerAZDistribution.wrap(value))
    override val clientSubnets: List[__string] = impl
      .clientSubnets()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val instanceType: __stringMin5Max32 =
      impl.instanceType(): __stringMin5Max32
    override val securityGroups: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val storageInfo
        : Optional[zio.aws.kafka.model.StorageInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageInfo())
        .map(value => zio.aws.kafka.model.StorageInfo.wrap(value))
    override val connectivityInfo
        : Optional[zio.aws.kafka.model.ConnectivityInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectivityInfo())
        .map(value => zio.aws.kafka.model.ConnectivityInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo
  ): zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly = new Wrapper(impl)
}
