package zio.aws.kafka.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__stringMin5Max32, __string, __integer}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MutableClusterInfo(
    brokerEBSVolumeInfo: Optional[
      Iterable[zio.aws.kafka.model.BrokerEBSVolumeInfo]
    ] = Optional.Absent,
    configurationInfo: Optional[zio.aws.kafka.model.ConfigurationInfo] =
      Optional.Absent,
    numberOfBrokerNodes: Optional[__integer] = Optional.Absent,
    enhancedMonitoring: Optional[zio.aws.kafka.model.EnhancedMonitoring] =
      Optional.Absent,
    openMonitoring: Optional[zio.aws.kafka.model.OpenMonitoring] =
      Optional.Absent,
    kafkaVersion: Optional[__string] = Optional.Absent,
    loggingInfo: Optional[zio.aws.kafka.model.LoggingInfo] = Optional.Absent,
    instanceType: Optional[__stringMin5Max32] = Optional.Absent,
    clientAuthentication: Optional[zio.aws.kafka.model.ClientAuthentication] =
      Optional.Absent,
    encryptionInfo: Optional[zio.aws.kafka.model.EncryptionInfo] =
      Optional.Absent,
    connectivityInfo: Optional[zio.aws.kafka.model.ConnectivityInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.MutableClusterInfo = {
    import MutableClusterInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.MutableClusterInfo
      .builder()
      .optionallyWith(
        brokerEBSVolumeInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.brokerEBSVolumeInfo)
      .optionallyWith(configurationInfo.map(value => value.buildAwsValue()))(
        _.configurationInfo
      )
      .optionallyWith(numberOfBrokerNodes.map(value => value: Integer))(
        _.numberOfBrokerNodes
      )
      .optionallyWith(enhancedMonitoring.map(value => value.unwrap))(
        _.enhancedMonitoring
      )
      .optionallyWith(openMonitoring.map(value => value.buildAwsValue()))(
        _.openMonitoring
      )
      .optionallyWith(kafkaVersion.map(value => value: java.lang.String))(
        _.kafkaVersion
      )
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .optionallyWith(encryptionInfo.map(value => value.buildAwsValue()))(
        _.encryptionInfo
      )
      .optionallyWith(connectivityInfo.map(value => value.buildAwsValue()))(
        _.connectivityInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.MutableClusterInfo.ReadOnly =
    zio.aws.kafka.model.MutableClusterInfo.wrap(buildAwsValue())
}
object MutableClusterInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.MutableClusterInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.MutableClusterInfo =
      zio.aws.kafka.model.MutableClusterInfo(
        brokerEBSVolumeInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationInfo.map(value => value.asEditable),
        numberOfBrokerNodes.map(value => value),
        enhancedMonitoring.map(value => value),
        openMonitoring.map(value => value.asEditable),
        kafkaVersion.map(value => value),
        loggingInfo.map(value => value.asEditable),
        instanceType.map(value => value),
        clientAuthentication.map(value => value.asEditable),
        encryptionInfo.map(value => value.asEditable),
        connectivityInfo.map(value => value.asEditable)
      )
    def brokerEBSVolumeInfo
        : Optional[List[zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly]]
    def configurationInfo
        : Optional[zio.aws.kafka.model.ConfigurationInfo.ReadOnly]
    def numberOfBrokerNodes: Optional[__integer]
    def enhancedMonitoring: Optional[zio.aws.kafka.model.EnhancedMonitoring]
    def openMonitoring: Optional[zio.aws.kafka.model.OpenMonitoring.ReadOnly]
    def kafkaVersion: Optional[__string]
    def loggingInfo: Optional[zio.aws.kafka.model.LoggingInfo.ReadOnly]
    def instanceType: Optional[__stringMin5Max32]
    def clientAuthentication
        : Optional[zio.aws.kafka.model.ClientAuthentication.ReadOnly]
    def encryptionInfo: Optional[zio.aws.kafka.model.EncryptionInfo.ReadOnly]
    def connectivityInfo
        : Optional[zio.aws.kafka.model.ConnectivityInfo.ReadOnly]
    def getBrokerEBSVolumeInfo: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("brokerEBSVolumeInfo", brokerEBSVolumeInfo)
    def getConfigurationInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ConfigurationInfo.ReadOnly] =
      AwsError.unwrapOptionField("configurationInfo", configurationInfo)
    def getNumberOfBrokerNodes: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("numberOfBrokerNodes", numberOfBrokerNodes)
    def getEnhancedMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.EnhancedMonitoring] =
      AwsError.unwrapOptionField("enhancedMonitoring", enhancedMonitoring)
    def getOpenMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.OpenMonitoring.ReadOnly] =
      AwsError.unwrapOptionField("openMonitoring", openMonitoring)
    def getKafkaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("kafkaVersion", kafkaVersion)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getInstanceType: ZIO[Any, AwsError, __stringMin5Max32] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
    def getEncryptionInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      AwsError.unwrapOptionField("encryptionInfo", encryptionInfo)
    def getConnectivityInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ConnectivityInfo.ReadOnly] =
      AwsError.unwrapOptionField("connectivityInfo", connectivityInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.MutableClusterInfo
  ) extends zio.aws.kafka.model.MutableClusterInfo.ReadOnly {
    override val brokerEBSVolumeInfo
        : Optional[List[zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.brokerEBSVolumeInfo())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.BrokerEBSVolumeInfo.wrap(item)
          }.toList
        )
    override val configurationInfo
        : Optional[zio.aws.kafka.model.ConfigurationInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationInfo())
        .map(value => zio.aws.kafka.model.ConfigurationInfo.wrap(value))
    override val numberOfBrokerNodes: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfBrokerNodes())
        .map(value => value: __integer)
    override val enhancedMonitoring
        : Optional[zio.aws.kafka.model.EnhancedMonitoring] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedMonitoring())
        .map(value => zio.aws.kafka.model.EnhancedMonitoring.wrap(value))
    override val openMonitoring
        : Optional[zio.aws.kafka.model.OpenMonitoring.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openMonitoring())
        .map(value => zio.aws.kafka.model.OpenMonitoring.wrap(value))
    override val kafkaVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.kafkaVersion())
      .map(value => value: __string)
    override val loggingInfo
        : Optional[zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingInfo())
        .map(value => zio.aws.kafka.model.LoggingInfo.wrap(value))
    override val instanceType: Optional[__stringMin5Max32] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => value: __stringMin5Max32)
    override val clientAuthentication
        : Optional[zio.aws.kafka.model.ClientAuthentication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientAuthentication())
        .map(value => zio.aws.kafka.model.ClientAuthentication.wrap(value))
    override val encryptionInfo
        : Optional[zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionInfo())
        .map(value => zio.aws.kafka.model.EncryptionInfo.wrap(value))
    override val connectivityInfo
        : Optional[zio.aws.kafka.model.ConnectivityInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectivityInfo())
        .map(value => zio.aws.kafka.model.ConnectivityInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.MutableClusterInfo
  ): zio.aws.kafka.model.MutableClusterInfo.ReadOnly = new Wrapper(impl)
}
