package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__double, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BrokerNodeInfo(
    attachedENIId: Optional[__string] = Optional.Absent,
    brokerId: Optional[__double] = Optional.Absent,
    clientSubnet: Optional[__string] = Optional.Absent,
    clientVpcIpAddress: Optional[__string] = Optional.Absent,
    currentBrokerSoftwareInfo: Optional[
      zio.aws.kafka.model.BrokerSoftwareInfo
    ] = Optional.Absent,
    endpoints: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BrokerNodeInfo = {
    import BrokerNodeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BrokerNodeInfo
      .builder()
      .optionallyWith(attachedENIId.map(value => value: java.lang.String))(
        _.attachedENIId
      )
      .optionallyWith(brokerId.map(value => value: java.lang.Double))(
        _.brokerId
      )
      .optionallyWith(clientSubnet.map(value => value: java.lang.String))(
        _.clientSubnet
      )
      .optionallyWith(clientVpcIpAddress.map(value => value: java.lang.String))(
        _.clientVpcIpAddress
      )
      .optionallyWith(
        currentBrokerSoftwareInfo.map(value => value.buildAwsValue())
      )(_.currentBrokerSoftwareInfo)
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.endpoints)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.BrokerNodeInfo.ReadOnly =
    zio.aws.kafka.model.BrokerNodeInfo.wrap(buildAwsValue())
}
object BrokerNodeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.BrokerNodeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BrokerNodeInfo =
      zio.aws.kafka.model.BrokerNodeInfo(
        attachedENIId.map(value => value),
        brokerId.map(value => value),
        clientSubnet.map(value => value),
        clientVpcIpAddress.map(value => value),
        currentBrokerSoftwareInfo.map(value => value.asEditable),
        endpoints.map(value => value)
      )
    def attachedENIId: Optional[__string]
    def brokerId: Optional[__double]
    def clientSubnet: Optional[__string]
    def clientVpcIpAddress: Optional[__string]
    def currentBrokerSoftwareInfo
        : Optional[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly]
    def endpoints: Optional[List[__string]]
    def getAttachedENIId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("attachedENIId", attachedENIId)
    def getBrokerId: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("brokerId", brokerId)
    def getClientSubnet: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientSubnet", clientSubnet)
    def getClientVpcIpAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientVpcIpAddress", clientVpcIpAddress)
    def getCurrentBrokerSoftwareInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] =
      AwsError.unwrapOptionField(
        "currentBrokerSoftwareInfo",
        currentBrokerSoftwareInfo
      )
    def getEndpoints: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("endpoints", endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BrokerNodeInfo
  ) extends zio.aws.kafka.model.BrokerNodeInfo.ReadOnly {
    override val attachedENIId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.attachedENIId())
      .map(value => value: __string)
    override val brokerId: Optional[__double] = zio.aws.core.internal
      .optionalFromNullable(impl.brokerId())
      .map(value => value: __double)
    override val clientSubnet: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientSubnet())
      .map(value => value: __string)
    override val clientVpcIpAddress: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientVpcIpAddress())
      .map(value => value: __string)
    override val currentBrokerSoftwareInfo
        : Optional[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentBrokerSoftwareInfo())
        .map(value => zio.aws.kafka.model.BrokerSoftwareInfo.wrap(value))
    override val endpoints: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoints())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BrokerNodeInfo
  ): zio.aws.kafka.model.BrokerNodeInfo.ReadOnly = new Wrapper(impl)
}
