package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UnprocessedScramSecret(
    errorCode: Optional[__string] = Optional.Absent,
    errorMessage: Optional[__string] = Optional.Absent,
    secretArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UnprocessedScramSecret = {
    import UnprocessedScramSecret.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UnprocessedScramSecret
      .builder()
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(secretArn.map(value => value: java.lang.String))(
        _.secretArn
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly =
    zio.aws.kafka.model.UnprocessedScramSecret.wrap(buildAwsValue())
}
object UnprocessedScramSecret {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UnprocessedScramSecret
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UnprocessedScramSecret =
      zio.aws.kafka.model.UnprocessedScramSecret(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        secretArn.map(value => value)
      )
    def errorCode: Optional[__string]
    def errorMessage: Optional[__string]
    def secretArn: Optional[__string]
    def getErrorCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getSecretArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("secretArn", secretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UnprocessedScramSecret
  ) extends zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly {
    override val errorCode: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: __string)
    override val errorMessage: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: __string)
    override val secretArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UnprocessedScramSecret
  ): zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly = new Wrapper(impl)
}
