package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BrokerLogs(
    cloudWatchLogs: Optional[zio.aws.kafka.model.CloudWatchLogs] =
      Optional.Absent,
    firehose: Optional[zio.aws.kafka.model.Firehose] = Optional.Absent,
    s3: Optional[zio.aws.kafka.model.S3] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BrokerLogs = {
    import BrokerLogs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BrokerLogs
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(firehose.map(value => value.buildAwsValue()))(_.firehose)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.BrokerLogs.ReadOnly =
    zio.aws.kafka.model.BrokerLogs.wrap(buildAwsValue())
}
object BrokerLogs {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.BrokerLogs] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BrokerLogs =
      zio.aws.kafka.model.BrokerLogs(
        cloudWatchLogs.map(value => value.asEditable),
        firehose.map(value => value.asEditable),
        s3.map(value => value.asEditable)
      )
    def cloudWatchLogs: Optional[zio.aws.kafka.model.CloudWatchLogs.ReadOnly]
    def firehose: Optional[zio.aws.kafka.model.Firehose.ReadOnly]
    def s3: Optional[zio.aws.kafka.model.S3.ReadOnly]
    def getCloudWatchLogs
        : ZIO[Any, AwsError, zio.aws.kafka.model.CloudWatchLogs.ReadOnly] =
      AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getFirehose: ZIO[Any, AwsError, zio.aws.kafka.model.Firehose.ReadOnly] =
      AwsError.unwrapOptionField("firehose", firehose)
    def getS3: ZIO[Any, AwsError, zio.aws.kafka.model.S3.ReadOnly] =
      AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BrokerLogs
  ) extends zio.aws.kafka.model.BrokerLogs.ReadOnly {
    override val cloudWatchLogs
        : Optional[zio.aws.kafka.model.CloudWatchLogs.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogs())
        .map(value => zio.aws.kafka.model.CloudWatchLogs.wrap(value))
    override val firehose: Optional[zio.aws.kafka.model.Firehose.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firehose())
        .map(value => zio.aws.kafka.model.Firehose.wrap(value))
    override val s3: Optional[zio.aws.kafka.model.S3.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.kafka.model.S3.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BrokerLogs
  ): zio.aws.kafka.model.BrokerLogs.ReadOnly = new Wrapper(impl)
}
