package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__boolean
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EncryptionInTransit(
    clientBroker: Option[zio.aws.kafka.model.ClientBroker] = None,
    inCluster: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.EncryptionInTransit = {
    import EncryptionInTransit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.EncryptionInTransit
      .builder()
      .optionallyWith(clientBroker.map(value => value.unwrap))(_.clientBroker)
      .optionallyWith(inCluster.map(value => value: java.lang.Boolean))(
        _.inCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.EncryptionInTransit.ReadOnly =
    zio.aws.kafka.model.EncryptionInTransit.wrap(buildAwsValue())
}
object EncryptionInTransit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.EncryptionInTransit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.EncryptionInTransit =
      zio.aws.kafka.model.EncryptionInTransit(
        clientBroker.map(value => value),
        inCluster.map(value => value)
      )
    def clientBroker: Option[zio.aws.kafka.model.ClientBroker]
    def inCluster: Option[__boolean]
    def getClientBroker: ZIO[Any, AwsError, zio.aws.kafka.model.ClientBroker] =
      AwsError.unwrapOptionField("clientBroker", clientBroker)
    def getInCluster: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("inCluster", inCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.EncryptionInTransit
  ) extends zio.aws.kafka.model.EncryptionInTransit.ReadOnly {
    override val clientBroker: Option[zio.aws.kafka.model.ClientBroker] = scala
      .Option(impl.clientBroker())
      .map(value => zio.aws.kafka.model.ClientBroker.wrap(value))
    override val inCluster: Option[__boolean] =
      scala.Option(impl.inCluster()).map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.EncryptionInTransit
  ): zio.aws.kafka.model.EncryptionInTransit.ReadOnly = new Wrapper(impl)
}
