package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteClusterRequest(
    clusterArn: __string,
    currentVersion: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DeleteClusterRequest = {
    import DeleteClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DeleteClusterRequest
      .builder()
      .clusterArn(clusterArn: java.lang.String)
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.DeleteClusterRequest.ReadOnly =
    zio.aws.kafka.model.DeleteClusterRequest.wrap(buildAwsValue())
}
object DeleteClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DeleteClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DeleteClusterRequest =
      zio.aws.kafka.model
        .DeleteClusterRequest(clusterArn, currentVersion.map(value => value))
    def clusterArn: __string
    def currentVersion: Option[__string]
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DeleteClusterRequest
  ) extends zio.aws.kafka.model.DeleteClusterRequest.ReadOnly {
    override val clusterArn: __string = impl.clusterArn(): __string
    override val currentVersion: Option[__string] =
      scala.Option(impl.currentVersion()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DeleteClusterRequest
  ): zio.aws.kafka.model.DeleteClusterRequest.ReadOnly = new Wrapper(impl)
}
