package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{MaxResults, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListNodesRequest(
    clusterArn: __string,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListNodesRequest = {
    import ListNodesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListNodesRequest
      .builder()
      .clusterArn(clusterArn: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListNodesRequest.ReadOnly =
    zio.aws.kafka.model.ListNodesRequest.wrap(buildAwsValue())
}
object ListNodesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListNodesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListNodesRequest =
      zio.aws.kafka.model.ListNodesRequest(
        clusterArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterArn: __string
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListNodesRequest
  ) extends zio.aws.kafka.model.ListNodesRequest.ReadOnly {
    override val clusterArn: __string = impl.clusterArn(): __string
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.kafka.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListNodesRequest
  ): zio.aws.kafka.model.ListNodesRequest.ReadOnly = new Wrapper(impl)
}
