package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteConfigurationResponse(
    arn: Option[__string] = None,
    state: Option[zio.aws.kafka.model.ConfigurationState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DeleteConfigurationResponse = {
    import DeleteConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DeleteConfigurationResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.DeleteConfigurationResponse.ReadOnly =
    zio.aws.kafka.model.DeleteConfigurationResponse.wrap(buildAwsValue())
}
object DeleteConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DeleteConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DeleteConfigurationResponse =
      zio.aws.kafka.model.DeleteConfigurationResponse(
        arn.map(value => value),
        state.map(value => value)
      )
    def arn: Option[__string]
    def state: Option[zio.aws.kafka.model.ConfigurationState]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ConfigurationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DeleteConfigurationResponse
  ) extends zio.aws.kafka.model.DeleteConfigurationResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val state: Option[zio.aws.kafka.model.ConfigurationState] = scala
      .Option(impl.state())
      .map(value => zio.aws.kafka.model.ConfigurationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DeleteConfigurationResponse
  ): zio.aws.kafka.model.DeleteConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
