package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateConfigurationResponse(
    arn: Option[__string] = None,
    latestRevision: Option[zio.aws.kafka.model.ConfigurationRevision] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse = {
    import UpdateConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(latestRevision.map(value => value.buildAwsValue()))(
        _.latestRevision
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateConfigurationResponse.ReadOnly =
    zio.aws.kafka.model.UpdateConfigurationResponse.wrap(buildAwsValue())
}
object UpdateConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateConfigurationResponse =
      zio.aws.kafka.model.UpdateConfigurationResponse(
        arn.map(value => value),
        latestRevision.map(value => value.asEditable)
      )
    def arn: Option[__string]
    def latestRevision
        : Option[zio.aws.kafka.model.ConfigurationRevision.ReadOnly]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getLatestRevision: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ConfigurationRevision.ReadOnly
    ] = AwsError.unwrapOptionField("latestRevision", latestRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse
  ) extends zio.aws.kafka.model.UpdateConfigurationResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val latestRevision
        : Option[zio.aws.kafka.model.ConfigurationRevision.ReadOnly] = scala
      .Option(impl.latestRevision())
      .map(value => zio.aws.kafka.model.ConfigurationRevision.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse
  ): zio.aws.kafka.model.UpdateConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
