package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{MaxResults, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListScramSecretsRequest(
    clusterArn: __string,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest = {
    import ListScramSecretsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest
      .builder()
      .clusterArn(clusterArn: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListScramSecretsRequest.ReadOnly =
    zio.aws.kafka.model.ListScramSecretsRequest.wrap(buildAwsValue())
}
object ListScramSecretsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListScramSecretsRequest =
      zio.aws.kafka.model.ListScramSecretsRequest(
        clusterArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterArn: __string
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest
  ) extends zio.aws.kafka.model.ListScramSecretsRequest.ReadOnly {
    override val clusterArn: __string = impl.clusterArn(): __string
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.kafka.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest
  ): zio.aws.kafka.model.ListScramSecretsRequest.ReadOnly = new Wrapper(impl)
}
