package zio.aws.kafka.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__integer, __timestampIso8601, __string}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ClusterInfo(
    activeOperationArn: Option[__string] = None,
    brokerNodeGroupInfo: Option[zio.aws.kafka.model.BrokerNodeGroupInfo] = None,
    clientAuthentication: Option[zio.aws.kafka.model.ClientAuthentication] =
      None,
    clusterArn: Option[__string] = None,
    clusterName: Option[__string] = None,
    creationTime: Option[__timestampIso8601] = None,
    currentBrokerSoftwareInfo: Option[zio.aws.kafka.model.BrokerSoftwareInfo] =
      None,
    currentVersion: Option[__string] = None,
    encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo] = None,
    enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring] = None,
    openMonitoring: Option[zio.aws.kafka.model.OpenMonitoring] = None,
    loggingInfo: Option[zio.aws.kafka.model.LoggingInfo] = None,
    numberOfBrokerNodes: Option[__integer] = None,
    state: Option[zio.aws.kafka.model.ClusterState] = None,
    stateInfo: Option[zio.aws.kafka.model.StateInfo] = None,
    tags: Option[Map[__string, __string]] = None,
    zookeeperConnectString: Option[__string] = None,
    zookeeperConnectStringTls: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClusterInfo = {
    import ClusterInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClusterInfo
      .builder()
      .optionallyWith(activeOperationArn.map(value => value: java.lang.String))(
        _.activeOperationArn
      )
      .optionallyWith(brokerNodeGroupInfo.map(value => value.buildAwsValue()))(
        _.brokerNodeGroupInfo
      )
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(
        currentBrokerSoftwareInfo.map(value => value.buildAwsValue())
      )(_.currentBrokerSoftwareInfo)
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .optionallyWith(encryptionInfo.map(value => value.buildAwsValue()))(
        _.encryptionInfo
      )
      .optionallyWith(enhancedMonitoring.map(value => value.unwrap))(
        _.enhancedMonitoring
      )
      .optionallyWith(openMonitoring.map(value => value.buildAwsValue()))(
        _.openMonitoring
      )
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .optionallyWith(numberOfBrokerNodes.map(value => value: Integer))(
        _.numberOfBrokerNodes
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateInfo.map(value => value.buildAwsValue()))(
        _.stateInfo
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        zookeeperConnectString.map(value => value: java.lang.String)
      )(_.zookeeperConnectString)
      .optionallyWith(
        zookeeperConnectStringTls.map(value => value: java.lang.String)
      )(_.zookeeperConnectStringTls)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClusterInfo.ReadOnly =
    zio.aws.kafka.model.ClusterInfo.wrap(buildAwsValue())
}
object ClusterInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.ClusterInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClusterInfo =
      zio.aws.kafka.model.ClusterInfo(
        activeOperationArn.map(value => value),
        brokerNodeGroupInfo.map(value => value.asEditable),
        clientAuthentication.map(value => value.asEditable),
        clusterArn.map(value => value),
        clusterName.map(value => value),
        creationTime.map(value => value),
        currentBrokerSoftwareInfo.map(value => value.asEditable),
        currentVersion.map(value => value),
        encryptionInfo.map(value => value.asEditable),
        enhancedMonitoring.map(value => value),
        openMonitoring.map(value => value.asEditable),
        loggingInfo.map(value => value.asEditable),
        numberOfBrokerNodes.map(value => value),
        state.map(value => value),
        stateInfo.map(value => value.asEditable),
        tags.map(value => value),
        zookeeperConnectString.map(value => value),
        zookeeperConnectStringTls.map(value => value)
      )
    def activeOperationArn: Option[__string]
    def brokerNodeGroupInfo
        : Option[zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly]
    def clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly]
    def clusterArn: Option[__string]
    def clusterName: Option[__string]
    def creationTime: Option[__timestampIso8601]
    def currentBrokerSoftwareInfo
        : Option[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly]
    def currentVersion: Option[__string]
    def encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly]
    def enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring]
    def openMonitoring: Option[zio.aws.kafka.model.OpenMonitoring.ReadOnly]
    def loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly]
    def numberOfBrokerNodes: Option[__integer]
    def state: Option[zio.aws.kafka.model.ClusterState]
    def stateInfo: Option[zio.aws.kafka.model.StateInfo.ReadOnly]
    def tags: Option[Map[__string, __string]]
    def zookeeperConnectString: Option[__string]
    def zookeeperConnectStringTls: Option[__string]
    def getActiveOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("activeOperationArn", activeOperationArn)
    def getBrokerNodeGroupInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly] =
      AwsError.unwrapOptionField("brokerNodeGroupInfo", brokerNodeGroupInfo)
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCurrentBrokerSoftwareInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] =
      AwsError.unwrapOptionField(
        "currentBrokerSoftwareInfo",
        currentBrokerSoftwareInfo
      )
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getEncryptionInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      AwsError.unwrapOptionField("encryptionInfo", encryptionInfo)
    def getEnhancedMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.EnhancedMonitoring] =
      AwsError.unwrapOptionField("enhancedMonitoring", enhancedMonitoring)
    def getOpenMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.OpenMonitoring.ReadOnly] =
      AwsError.unwrapOptionField("openMonitoring", openMonitoring)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getNumberOfBrokerNodes: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("numberOfBrokerNodes", numberOfBrokerNodes)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
    def getStateInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.StateInfo.ReadOnly] =
      AwsError.unwrapOptionField("stateInfo", stateInfo)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getZookeeperConnectString: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("zookeeperConnectString", zookeeperConnectString)
    def getZookeeperConnectStringTls: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("zookeeperConnectStringTls", zookeeperConnectStringTls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClusterInfo
  ) extends zio.aws.kafka.model.ClusterInfo.ReadOnly {
    override val activeOperationArn: Option[__string] =
      scala.Option(impl.activeOperationArn()).map(value => value: __string)
    override val brokerNodeGroupInfo
        : Option[zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly] = scala
      .Option(impl.brokerNodeGroupInfo())
      .map(value => zio.aws.kafka.model.BrokerNodeGroupInfo.wrap(value))
    override val clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly] = scala
      .Option(impl.clientAuthentication())
      .map(value => zio.aws.kafka.model.ClientAuthentication.wrap(value))
    override val clusterArn: Option[__string] =
      scala.Option(impl.clusterArn()).map(value => value: __string)
    override val clusterName: Option[__string] =
      scala.Option(impl.clusterName()).map(value => value: __string)
    override val creationTime: Option[__timestampIso8601] =
      scala.Option(impl.creationTime()).map(value => value: __timestampIso8601)
    override val currentBrokerSoftwareInfo
        : Option[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] = scala
      .Option(impl.currentBrokerSoftwareInfo())
      .map(value => zio.aws.kafka.model.BrokerSoftwareInfo.wrap(value))
    override val currentVersion: Option[__string] =
      scala.Option(impl.currentVersion()).map(value => value: __string)
    override val encryptionInfo
        : Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly] = scala
      .Option(impl.encryptionInfo())
      .map(value => zio.aws.kafka.model.EncryptionInfo.wrap(value))
    override val enhancedMonitoring
        : Option[zio.aws.kafka.model.EnhancedMonitoring] = scala
      .Option(impl.enhancedMonitoring())
      .map(value => zio.aws.kafka.model.EnhancedMonitoring.wrap(value))
    override val openMonitoring
        : Option[zio.aws.kafka.model.OpenMonitoring.ReadOnly] = scala
      .Option(impl.openMonitoring())
      .map(value => zio.aws.kafka.model.OpenMonitoring.wrap(value))
    override val loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      scala
        .Option(impl.loggingInfo())
        .map(value => zio.aws.kafka.model.LoggingInfo.wrap(value))
    override val numberOfBrokerNodes: Option[__integer] =
      scala.Option(impl.numberOfBrokerNodes()).map(value => value: __integer)
    override val state: Option[zio.aws.kafka.model.ClusterState] = scala
      .Option(impl.state())
      .map(value => zio.aws.kafka.model.ClusterState.wrap(value))
    override val stateInfo: Option[zio.aws.kafka.model.StateInfo.ReadOnly] =
      scala
        .Option(impl.stateInfo())
        .map(value => zio.aws.kafka.model.StateInfo.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val zookeeperConnectString: Option[__string] =
      scala.Option(impl.zookeeperConnectString()).map(value => value: __string)
    override val zookeeperConnectStringTls: Option[__string] = scala
      .Option(impl.zookeeperConnectStringTls())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClusterInfo
  ): zio.aws.kafka.model.ClusterInfo.ReadOnly = new Wrapper(impl)
}
