package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSecurityResponse(
    clusterArn: Option[__string] = None,
    clusterOperationArn: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse = {
    import UpdateSecurityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(
        clusterOperationArn.map(value => value: java.lang.String)
      )(_.clusterOperationArn)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateSecurityResponse.ReadOnly =
    zio.aws.kafka.model.UpdateSecurityResponse.wrap(buildAwsValue())
}
object UpdateSecurityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateSecurityResponse =
      zio.aws.kafka.model.UpdateSecurityResponse(
        clusterArn.map(value => value),
        clusterOperationArn.map(value => value)
      )
    def clusterArn: Option[__string]
    def clusterOperationArn: Option[__string]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterOperationArn", clusterOperationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse
  ) extends zio.aws.kafka.model.UpdateSecurityResponse.ReadOnly {
    override val clusterArn: Option[__string] =
      scala.Option(impl.clusterArn()).map(value => value: __string)
    override val clusterOperationArn: Option[__string] =
      scala.Option(impl.clusterOperationArn()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse
  ): zio.aws.kafka.model.UpdateSecurityResponse.ReadOnly = new Wrapper(impl)
}
