package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__double, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BrokerNodeInfo(
    attachedENIId: Option[__string] = None,
    brokerId: Option[__double] = None,
    clientSubnet: Option[__string] = None,
    clientVpcIpAddress: Option[__string] = None,
    currentBrokerSoftwareInfo: Option[zio.aws.kafka.model.BrokerSoftwareInfo] =
      None,
    endpoints: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BrokerNodeInfo = {
    import BrokerNodeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BrokerNodeInfo
      .builder()
      .optionallyWith(attachedENIId.map(value => value: java.lang.String))(
        _.attachedENIId
      )
      .optionallyWith(brokerId.map(value => value: java.lang.Double))(
        _.brokerId
      )
      .optionallyWith(clientSubnet.map(value => value: java.lang.String))(
        _.clientSubnet
      )
      .optionallyWith(clientVpcIpAddress.map(value => value: java.lang.String))(
        _.clientVpcIpAddress
      )
      .optionallyWith(
        currentBrokerSoftwareInfo.map(value => value.buildAwsValue())
      )(_.currentBrokerSoftwareInfo)
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.endpoints)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.BrokerNodeInfo.ReadOnly =
    zio.aws.kafka.model.BrokerNodeInfo.wrap(buildAwsValue())
}
object BrokerNodeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.BrokerNodeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BrokerNodeInfo =
      zio.aws.kafka.model.BrokerNodeInfo(
        attachedENIId.map(value => value),
        brokerId.map(value => value),
        clientSubnet.map(value => value),
        clientVpcIpAddress.map(value => value),
        currentBrokerSoftwareInfo.map(value => value.asEditable),
        endpoints.map(value => value)
      )
    def attachedENIId: Option[__string]
    def brokerId: Option[__double]
    def clientSubnet: Option[__string]
    def clientVpcIpAddress: Option[__string]
    def currentBrokerSoftwareInfo
        : Option[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly]
    def endpoints: Option[List[__string]]
    def getAttachedENIId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("attachedENIId", attachedENIId)
    def getBrokerId: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("brokerId", brokerId)
    def getClientSubnet: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientSubnet", clientSubnet)
    def getClientVpcIpAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientVpcIpAddress", clientVpcIpAddress)
    def getCurrentBrokerSoftwareInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] =
      AwsError.unwrapOptionField(
        "currentBrokerSoftwareInfo",
        currentBrokerSoftwareInfo
      )
    def getEndpoints: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("endpoints", endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BrokerNodeInfo
  ) extends zio.aws.kafka.model.BrokerNodeInfo.ReadOnly {
    override val attachedENIId: Option[__string] =
      scala.Option(impl.attachedENIId()).map(value => value: __string)
    override val brokerId: Option[__double] =
      scala.Option(impl.brokerId()).map(value => value: __double)
    override val clientSubnet: Option[__string] =
      scala.Option(impl.clientSubnet()).map(value => value: __string)
    override val clientVpcIpAddress: Option[__string] =
      scala.Option(impl.clientVpcIpAddress()).map(value => value: __string)
    override val currentBrokerSoftwareInfo
        : Option[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] = scala
      .Option(impl.currentBrokerSoftwareInfo())
      .map(value => zio.aws.kafka.model.BrokerSoftwareInfo.wrap(value))
    override val endpoints: Option[List[__string]] = scala
      .Option(impl.endpoints())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BrokerNodeInfo
  ): zio.aws.kafka.model.BrokerNodeInfo.ReadOnly = new Wrapper(impl)
}
