package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{MaxResults, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListClustersV2Request(
    clusterNameFilter: Option[__string] = None,
    clusterTypeFilter: Option[__string] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClustersV2Request = {
    import ListClustersV2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClustersV2Request
      .builder()
      .optionallyWith(clusterNameFilter.map(value => value: java.lang.String))(
        _.clusterNameFilter
      )
      .optionallyWith(clusterTypeFilter.map(value => value: java.lang.String))(
        _.clusterTypeFilter
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListClustersV2Request.ReadOnly =
    zio.aws.kafka.model.ListClustersV2Request.wrap(buildAwsValue())
}
object ListClustersV2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClustersV2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClustersV2Request =
      zio.aws.kafka.model.ListClustersV2Request(
        clusterNameFilter.map(value => value),
        clusterTypeFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterNameFilter: Option[__string]
    def clusterTypeFilter: Option[__string]
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getClusterNameFilter: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterNameFilter", clusterNameFilter)
    def getClusterTypeFilter: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterTypeFilter", clusterTypeFilter)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersV2Request
  ) extends zio.aws.kafka.model.ListClustersV2Request.ReadOnly {
    override val clusterNameFilter: Option[__string] =
      scala.Option(impl.clusterNameFilter()).map(value => value: __string)
    override val clusterTypeFilter: Option[__string] =
      scala.Option(impl.clusterTypeFilter()).map(value => value: __string)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.kafka.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersV2Request
  ): zio.aws.kafka.model.ListClustersV2Request.ReadOnly = new Wrapper(impl)
}
