package zio.aws.kafka
import zio.aws.kafka.model.GetBootstrapBrokersResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.kafka.{
  KafkaAsyncClientBuilder,
  KafkaAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.kafka.model.{
  BatchAssociateScramSecretRequest,
  CreateClusterV2Response,
  UpdateClusterKafkaVersionRequest,
  ClusterOperationInfo,
  ListNodesResponse,
  Cluster,
  UpdateClusterKafkaVersionResponse,
  GetBootstrapBrokersRequest,
  GetCompatibleKafkaVersionsRequest,
  UpdateBrokerTypeRequest,
  DescribeConfigurationRevisionRequest,
  ListNodesRequest,
  DescribeClusterOperationResponse,
  DeleteConfigurationRequest,
  DescribeConfigurationRequest,
  UpdateSecurityRequest,
  CreateClusterV2Request,
  ListClustersV2Response,
  ListKafkaVersionsRequest,
  ListTagsForResourceRequest,
  UpdateConfigurationRequest,
  NodeInfo,
  UpdateConfigurationResponse,
  CreateClusterRequest,
  DescribeClusterResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateConfigurationRequest,
  CreateClusterResponse,
  ListConfigurationsResponse,
  DeleteClusterRequest,
  ListClusterOperationsRequest,
  ListClusterOperationsResponse,
  DescribeClusterV2Request,
  ListClustersV2Request,
  ListConfigurationRevisionsResponse,
  UpdateBrokerTypeResponse,
  ConfigurationRevision,
  UpdateClusterConfigurationRequest,
  DeleteConfigurationResponse,
  UntagResourceRequest,
  UpdateMonitoringRequest,
  UpdateBrokerStorageRequest,
  Configuration,
  UpdateConnectivityResponse,
  DescribeConfigurationResponse,
  UpdateBrokerCountResponse,
  DescribeClusterRequest,
  KafkaVersion,
  BatchAssociateScramSecretResponse,
  ListScramSecretsResponse,
  GetCompatibleKafkaVersionsResponse,
  DeleteClusterResponse,
  BatchDisassociateScramSecretResponse,
  ClusterInfo,
  ListKafkaVersionsResponse,
  ListConfigurationRevisionsRequest,
  DescribeClusterV2Response,
  CreateConfigurationResponse,
  RebootBrokerRequest,
  GetBootstrapBrokersResponse,
  TagResourceResponse,
  UpdateBrokerCountRequest,
  UpdateClusterConfigurationResponse,
  ListClustersRequest,
  DescribeConfigurationRevisionResponse,
  UpdateSecurityResponse,
  DescribeClusterOperationRequest,
  TagResourceRequest,
  BatchDisassociateScramSecretRequest,
  UpdateConnectivityRequest,
  ListConfigurationsRequest,
  ListClustersResponse,
  ListScramSecretsRequest,
  UpdateBrokerStorageResponse,
  UpdateMonitoringResponse,
  RebootBrokerResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.aws.kafka.model.primitives.__string
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Kafka extends AspectSupport[Kafka] {
  val api: KafkaAsyncClient
  def describeClusterV2(
      request: zio.aws.kafka.model.DescribeClusterV2Request
  ): IO[AwsError, zio.aws.kafka.model.DescribeClusterV2Response.ReadOnly]
  def deleteConfiguration(
      request: zio.aws.kafka.model.DeleteConfigurationRequest
  ): IO[AwsError, zio.aws.kafka.model.DeleteConfigurationResponse.ReadOnly]
  def batchDisassociateScramSecret(
      request: zio.aws.kafka.model.BatchDisassociateScramSecretRequest
  ): IO[
    AwsError,
    zio.aws.kafka.model.BatchDisassociateScramSecretResponse.ReadOnly
  ]
  def createConfiguration(
      request: zio.aws.kafka.model.CreateConfigurationRequest
  ): IO[AwsError, zio.aws.kafka.model.CreateConfigurationResponse.ReadOnly]
  def batchAssociateScramSecret(
      request: zio.aws.kafka.model.BatchAssociateScramSecretRequest
  ): IO[
    AwsError,
    zio.aws.kafka.model.BatchAssociateScramSecretResponse.ReadOnly
  ]
  def updateConfiguration(
      request: zio.aws.kafka.model.UpdateConfigurationRequest
  ): IO[AwsError, zio.aws.kafka.model.UpdateConfigurationResponse.ReadOnly]
  def rebootBroker(
      request: zio.aws.kafka.model.RebootBrokerRequest
  ): IO[AwsError, zio.aws.kafka.model.RebootBrokerResponse.ReadOnly]
  def updateSecurity(
      request: zio.aws.kafka.model.UpdateSecurityRequest
  ): IO[AwsError, zio.aws.kafka.model.UpdateSecurityResponse.ReadOnly]
  def getBootstrapBrokers(
      request: zio.aws.kafka.model.GetBootstrapBrokersRequest
  ): IO[AwsError, ReadOnly]
  def createCluster(
      request: zio.aws.kafka.model.CreateClusterRequest
  ): IO[AwsError, zio.aws.kafka.model.CreateClusterResponse.ReadOnly]
  def deleteCluster(
      request: zio.aws.kafka.model.DeleteClusterRequest
  ): IO[AwsError, zio.aws.kafka.model.DeleteClusterResponse.ReadOnly]
  def listClusterOperations(
      request: zio.aws.kafka.model.ListClusterOperationsRequest
  ): ZStream[Any, AwsError, zio.aws.kafka.model.ClusterOperationInfo.ReadOnly]
  def listClusterOperationsPaginated(
      request: zio.aws.kafka.model.ListClusterOperationsRequest
  ): IO[AwsError, zio.aws.kafka.model.ListClusterOperationsResponse.ReadOnly]
  def updateBrokerType(
      request: zio.aws.kafka.model.UpdateBrokerTypeRequest
  ): IO[AwsError, zio.aws.kafka.model.UpdateBrokerTypeResponse.ReadOnly]
  def describeClusterOperation(
      request: zio.aws.kafka.model.DescribeClusterOperationRequest
  ): IO[AwsError, zio.aws.kafka.model.DescribeClusterOperationResponse.ReadOnly]
  def listConfigurations(
      request: zio.aws.kafka.model.ListConfigurationsRequest
  ): ZStream[Any, AwsError, zio.aws.kafka.model.Configuration.ReadOnly]
  def listConfigurationsPaginated(
      request: zio.aws.kafka.model.ListConfigurationsRequest
  ): IO[AwsError, zio.aws.kafka.model.ListConfigurationsResponse.ReadOnly]
  def createClusterV2(
      request: zio.aws.kafka.model.CreateClusterV2Request
  ): IO[AwsError, zio.aws.kafka.model.CreateClusterV2Response.ReadOnly]
  def listScramSecrets(
      request: zio.aws.kafka.model.ListScramSecretsRequest
  ): ZStream[Any, AwsError, __string]
  def listScramSecretsPaginated(
      request: zio.aws.kafka.model.ListScramSecretsRequest
  ): IO[AwsError, zio.aws.kafka.model.ListScramSecretsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.kafka.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def updateClusterKafkaVersion(
      request: zio.aws.kafka.model.UpdateClusterKafkaVersionRequest
  ): IO[
    AwsError,
    zio.aws.kafka.model.UpdateClusterKafkaVersionResponse.ReadOnly
  ]
  def describeConfiguration(
      request: zio.aws.kafka.model.DescribeConfigurationRequest
  ): IO[AwsError, zio.aws.kafka.model.DescribeConfigurationResponse.ReadOnly]
  def describeCluster(
      request: zio.aws.kafka.model.DescribeClusterRequest
  ): IO[AwsError, zio.aws.kafka.model.DescribeClusterResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.kafka.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.kafka.model.ListTagsForResourceResponse.ReadOnly]
  def listClusters(
      request: zio.aws.kafka.model.ListClustersRequest
  ): ZStream[Any, AwsError, zio.aws.kafka.model.ClusterInfo.ReadOnly]
  def listClustersPaginated(
      request: zio.aws.kafka.model.ListClustersRequest
  ): IO[AwsError, zio.aws.kafka.model.ListClustersResponse.ReadOnly]
  def tagResource(
      request: zio.aws.kafka.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def getCompatibleKafkaVersions(
      request: zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest
  ): IO[
    AwsError,
    zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse.ReadOnly
  ]
  def updateClusterConfiguration(
      request: zio.aws.kafka.model.UpdateClusterConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.kafka.model.UpdateClusterConfigurationResponse.ReadOnly
  ]
  def updateConnectivity(
      request: zio.aws.kafka.model.UpdateConnectivityRequest
  ): IO[AwsError, zio.aws.kafka.model.UpdateConnectivityResponse.ReadOnly]
  def updateBrokerCount(
      request: zio.aws.kafka.model.UpdateBrokerCountRequest
  ): IO[AwsError, zio.aws.kafka.model.UpdateBrokerCountResponse.ReadOnly]
  def describeConfigurationRevision(
      request: zio.aws.kafka.model.DescribeConfigurationRevisionRequest
  ): IO[
    AwsError,
    zio.aws.kafka.model.DescribeConfigurationRevisionResponse.ReadOnly
  ]
  def updateBrokerStorage(
      request: zio.aws.kafka.model.UpdateBrokerStorageRequest
  ): IO[AwsError, zio.aws.kafka.model.UpdateBrokerStorageResponse.ReadOnly]
  def listKafkaVersions(
      request: zio.aws.kafka.model.ListKafkaVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.kafka.model.KafkaVersion.ReadOnly]
  def listKafkaVersionsPaginated(
      request: zio.aws.kafka.model.ListKafkaVersionsRequest
  ): IO[AwsError, zio.aws.kafka.model.ListKafkaVersionsResponse.ReadOnly]
  def listConfigurationRevisions(
      request: zio.aws.kafka.model.ListConfigurationRevisionsRequest
  ): ZStream[Any, AwsError, zio.aws.kafka.model.ConfigurationRevision.ReadOnly]
  def listConfigurationRevisionsPaginated(
      request: zio.aws.kafka.model.ListConfigurationRevisionsRequest
  ): IO[
    AwsError,
    zio.aws.kafka.model.ListConfigurationRevisionsResponse.ReadOnly
  ]
  def updateMonitoring(
      request: zio.aws.kafka.model.UpdateMonitoringRequest
  ): IO[AwsError, zio.aws.kafka.model.UpdateMonitoringResponse.ReadOnly]
  def listNodes(
      request: zio.aws.kafka.model.ListNodesRequest
  ): ZStream[Any, AwsError, zio.aws.kafka.model.NodeInfo.ReadOnly]
  def listNodesPaginated(
      request: zio.aws.kafka.model.ListNodesRequest
  ): IO[AwsError, zio.aws.kafka.model.ListNodesResponse.ReadOnly]
  def listClustersV2(
      request: zio.aws.kafka.model.ListClustersV2Request
  ): ZStream[Any, AwsError, zio.aws.kafka.model.Cluster.ReadOnly]
  def listClustersV2Paginated(
      request: zio.aws.kafka.model.ListClustersV2Request
  ): IO[AwsError, zio.aws.kafka.model.ListClustersV2Response.ReadOnly]
}
object Kafka {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Kafka] = customized(identity)
  def customized(
      customization: KafkaAsyncClientBuilder => KafkaAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Kafka] = managed(
    customization
  ).toLayer
  def managed(
      customization: KafkaAsyncClientBuilder => KafkaAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Kafka] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = KafkaAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[KafkaAsyncClient, KafkaAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[KafkaAsyncClient, KafkaAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new KafkaImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class KafkaImpl[R](
      override val api: KafkaAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Kafka
      with AwsServiceBase[R] {
    override val serviceName: String = "Kafka"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): KafkaImpl[R1] = new KafkaImpl(api, newAspect, r)
    def describeClusterV2(
        request: zio.aws.kafka.model.DescribeClusterV2Request
    ): IO[AwsError, zio.aws.kafka.model.DescribeClusterV2Response.ReadOnly] =
      asyncRequestResponse[DescribeClusterV2Request, DescribeClusterV2Response](
        "describeClusterV2",
        api.describeClusterV2
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.DescribeClusterV2Response.wrap)
        .provideEnvironment(r)
    def deleteConfiguration(
        request: zio.aws.kafka.model.DeleteConfigurationRequest
    ): IO[AwsError, zio.aws.kafka.model.DeleteConfigurationResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteConfigurationRequest,
        DeleteConfigurationResponse
      ]("deleteConfiguration", api.deleteConfiguration)(request.buildAwsValue())
        .map(zio.aws.kafka.model.DeleteConfigurationResponse.wrap)
        .provideEnvironment(r)
    def batchDisassociateScramSecret(
        request: zio.aws.kafka.model.BatchDisassociateScramSecretRequest
    ): IO[
      AwsError,
      zio.aws.kafka.model.BatchDisassociateScramSecretResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchDisassociateScramSecretRequest,
      BatchDisassociateScramSecretResponse
    ]("batchDisassociateScramSecret", api.batchDisassociateScramSecret)(
      request.buildAwsValue()
    ).map(zio.aws.kafka.model.BatchDisassociateScramSecretResponse.wrap)
      .provideEnvironment(r)
    def createConfiguration(
        request: zio.aws.kafka.model.CreateConfigurationRequest
    ): IO[AwsError, zio.aws.kafka.model.CreateConfigurationResponse.ReadOnly] =
      asyncRequestResponse[
        CreateConfigurationRequest,
        CreateConfigurationResponse
      ]("createConfiguration", api.createConfiguration)(request.buildAwsValue())
        .map(zio.aws.kafka.model.CreateConfigurationResponse.wrap)
        .provideEnvironment(r)
    def batchAssociateScramSecret(
        request: zio.aws.kafka.model.BatchAssociateScramSecretRequest
    ): IO[
      AwsError,
      zio.aws.kafka.model.BatchAssociateScramSecretResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchAssociateScramSecretRequest,
      BatchAssociateScramSecretResponse
    ]("batchAssociateScramSecret", api.batchAssociateScramSecret)(
      request.buildAwsValue()
    ).map(zio.aws.kafka.model.BatchAssociateScramSecretResponse.wrap)
      .provideEnvironment(r)
    def updateConfiguration(
        request: zio.aws.kafka.model.UpdateConfigurationRequest
    ): IO[AwsError, zio.aws.kafka.model.UpdateConfigurationResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateConfigurationRequest,
        UpdateConfigurationResponse
      ]("updateConfiguration", api.updateConfiguration)(request.buildAwsValue())
        .map(zio.aws.kafka.model.UpdateConfigurationResponse.wrap)
        .provideEnvironment(r)
    def rebootBroker(
        request: zio.aws.kafka.model.RebootBrokerRequest
    ): IO[AwsError, zio.aws.kafka.model.RebootBrokerResponse.ReadOnly] =
      asyncRequestResponse[RebootBrokerRequest, RebootBrokerResponse](
        "rebootBroker",
        api.rebootBroker
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.RebootBrokerResponse.wrap)
        .provideEnvironment(r)
    def updateSecurity(
        request: zio.aws.kafka.model.UpdateSecurityRequest
    ): IO[AwsError, zio.aws.kafka.model.UpdateSecurityResponse.ReadOnly] =
      asyncRequestResponse[UpdateSecurityRequest, UpdateSecurityResponse](
        "updateSecurity",
        api.updateSecurity
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.UpdateSecurityResponse.wrap)
        .provideEnvironment(r)
    def getBootstrapBrokers(
        request: zio.aws.kafka.model.GetBootstrapBrokersRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      GetBootstrapBrokersRequest,
      GetBootstrapBrokersResponse
    ]("getBootstrapBrokers", api.getBootstrapBrokers)(request.buildAwsValue())
      .map(zio.aws.kafka.model.GetBootstrapBrokersResponse.wrap)
      .provideEnvironment(r)
    def createCluster(
        request: zio.aws.kafka.model.CreateClusterRequest
    ): IO[AwsError, zio.aws.kafka.model.CreateClusterResponse.ReadOnly] =
      asyncRequestResponse[CreateClusterRequest, CreateClusterResponse](
        "createCluster",
        api.createCluster
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.CreateClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteCluster(
        request: zio.aws.kafka.model.DeleteClusterRequest
    ): IO[AwsError, zio.aws.kafka.model.DeleteClusterResponse.ReadOnly] =
      asyncRequestResponse[DeleteClusterRequest, DeleteClusterResponse](
        "deleteCluster",
        api.deleteCluster
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.DeleteClusterResponse.wrap)
        .provideEnvironment(r)
    def listClusterOperations(
        request: zio.aws.kafka.model.ListClusterOperationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kafka.model.ClusterOperationInfo.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListClusterOperationsRequest,
      ListClusterOperationsResponse,
      ClusterOperationInfo
    ](
      "listClusterOperations",
      api.listClusterOperations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.clusterOperationInfoList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.kafka.model.ClusterOperationInfo.wrap(item))
      .provideEnvironment(r)
    def listClusterOperationsPaginated(
        request: zio.aws.kafka.model.ListClusterOperationsRequest
    ): IO[
      AwsError,
      zio.aws.kafka.model.ListClusterOperationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListClusterOperationsRequest,
      ListClusterOperationsResponse
    ]("listClusterOperations", api.listClusterOperations)(
      request.buildAwsValue()
    ).map(zio.aws.kafka.model.ListClusterOperationsResponse.wrap)
      .provideEnvironment(r)
    def updateBrokerType(
        request: zio.aws.kafka.model.UpdateBrokerTypeRequest
    ): IO[AwsError, zio.aws.kafka.model.UpdateBrokerTypeResponse.ReadOnly] =
      asyncRequestResponse[UpdateBrokerTypeRequest, UpdateBrokerTypeResponse](
        "updateBrokerType",
        api.updateBrokerType
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.UpdateBrokerTypeResponse.wrap)
        .provideEnvironment(r)
    def describeClusterOperation(
        request: zio.aws.kafka.model.DescribeClusterOperationRequest
    ): IO[
      AwsError,
      zio.aws.kafka.model.DescribeClusterOperationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeClusterOperationRequest,
      DescribeClusterOperationResponse
    ]("describeClusterOperation", api.describeClusterOperation)(
      request.buildAwsValue()
    ).map(zio.aws.kafka.model.DescribeClusterOperationResponse.wrap)
      .provideEnvironment(r)
    def listConfigurations(
        request: zio.aws.kafka.model.ListConfigurationsRequest
    ): ZStream[Any, AwsError, zio.aws.kafka.model.Configuration.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListConfigurationsRequest,
        ListConfigurationsResponse,
        Configuration
      ](
        "listConfigurations",
        api.listConfigurations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.configurations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kafka.model.Configuration.wrap(item))
        .provideEnvironment(r)
    def listConfigurationsPaginated(
        request: zio.aws.kafka.model.ListConfigurationsRequest
    ): IO[AwsError, zio.aws.kafka.model.ListConfigurationsResponse.ReadOnly] =
      asyncRequestResponse[
        ListConfigurationsRequest,
        ListConfigurationsResponse
      ]("listConfigurations", api.listConfigurations)(request.buildAwsValue())
        .map(zio.aws.kafka.model.ListConfigurationsResponse.wrap)
        .provideEnvironment(r)
    def createClusterV2(
        request: zio.aws.kafka.model.CreateClusterV2Request
    ): IO[AwsError, zio.aws.kafka.model.CreateClusterV2Response.ReadOnly] =
      asyncRequestResponse[CreateClusterV2Request, CreateClusterV2Response](
        "createClusterV2",
        api.createClusterV2
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.CreateClusterV2Response.wrap)
        .provideEnvironment(r)
    def listScramSecrets(
        request: zio.aws.kafka.model.ListScramSecretsRequest
    ): ZStream[Any, AwsError, __string] = asyncSimplePaginatedRequest[
      ListScramSecretsRequest,
      ListScramSecretsResponse,
      java.lang.String
    ](
      "listScramSecrets",
      api.listScramSecrets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.secretArnList().asScala)
    )(request.buildAwsValue()).map(item => item: __string).provideEnvironment(r)
    def listScramSecretsPaginated(
        request: zio.aws.kafka.model.ListScramSecretsRequest
    ): IO[AwsError, zio.aws.kafka.model.ListScramSecretsResponse.ReadOnly] =
      asyncRequestResponse[ListScramSecretsRequest, ListScramSecretsResponse](
        "listScramSecrets",
        api.listScramSecrets
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.ListScramSecretsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.kafka.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateClusterKafkaVersion(
        request: zio.aws.kafka.model.UpdateClusterKafkaVersionRequest
    ): IO[
      AwsError,
      zio.aws.kafka.model.UpdateClusterKafkaVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateClusterKafkaVersionRequest,
      UpdateClusterKafkaVersionResponse
    ]("updateClusterKafkaVersion", api.updateClusterKafkaVersion)(
      request.buildAwsValue()
    ).map(zio.aws.kafka.model.UpdateClusterKafkaVersionResponse.wrap)
      .provideEnvironment(r)
    def describeConfiguration(
        request: zio.aws.kafka.model.DescribeConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.kafka.model.DescribeConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConfigurationRequest,
      DescribeConfigurationResponse
    ]("describeConfiguration", api.describeConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.kafka.model.DescribeConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeCluster(
        request: zio.aws.kafka.model.DescribeClusterRequest
    ): IO[AwsError, zio.aws.kafka.model.DescribeClusterResponse.ReadOnly] =
      asyncRequestResponse[DescribeClusterRequest, DescribeClusterResponse](
        "describeCluster",
        api.describeCluster
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.DescribeClusterResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.kafka.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.kafka.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.kafka.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def listClusters(
        request: zio.aws.kafka.model.ListClustersRequest
    ): ZStream[Any, AwsError, zio.aws.kafka.model.ClusterInfo.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListClustersRequest,
        ListClustersResponse,
        ClusterInfo
      ](
        "listClusters",
        api.listClusters,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.clusterInfoList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kafka.model.ClusterInfo.wrap(item))
        .provideEnvironment(r)
    def listClustersPaginated(
        request: zio.aws.kafka.model.ListClustersRequest
    ): IO[AwsError, zio.aws.kafka.model.ListClustersResponse.ReadOnly] =
      asyncRequestResponse[ListClustersRequest, ListClustersResponse](
        "listClusters",
        api.listClusters
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.ListClustersResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.kafka.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getCompatibleKafkaVersions(
        request: zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest
    ): IO[
      AwsError,
      zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCompatibleKafkaVersionsRequest,
      GetCompatibleKafkaVersionsResponse
    ]("getCompatibleKafkaVersions", api.getCompatibleKafkaVersions)(
      request.buildAwsValue()
    ).map(zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse.wrap)
      .provideEnvironment(r)
    def updateClusterConfiguration(
        request: zio.aws.kafka.model.UpdateClusterConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.kafka.model.UpdateClusterConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateClusterConfigurationRequest,
      UpdateClusterConfigurationResponse
    ]("updateClusterConfiguration", api.updateClusterConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.kafka.model.UpdateClusterConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateConnectivity(
        request: zio.aws.kafka.model.UpdateConnectivityRequest
    ): IO[AwsError, zio.aws.kafka.model.UpdateConnectivityResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateConnectivityRequest,
        UpdateConnectivityResponse
      ]("updateConnectivity", api.updateConnectivity)(request.buildAwsValue())
        .map(zio.aws.kafka.model.UpdateConnectivityResponse.wrap)
        .provideEnvironment(r)
    def updateBrokerCount(
        request: zio.aws.kafka.model.UpdateBrokerCountRequest
    ): IO[AwsError, zio.aws.kafka.model.UpdateBrokerCountResponse.ReadOnly] =
      asyncRequestResponse[UpdateBrokerCountRequest, UpdateBrokerCountResponse](
        "updateBrokerCount",
        api.updateBrokerCount
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.UpdateBrokerCountResponse.wrap)
        .provideEnvironment(r)
    def describeConfigurationRevision(
        request: zio.aws.kafka.model.DescribeConfigurationRevisionRequest
    ): IO[
      AwsError,
      zio.aws.kafka.model.DescribeConfigurationRevisionResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConfigurationRevisionRequest,
      DescribeConfigurationRevisionResponse
    ]("describeConfigurationRevision", api.describeConfigurationRevision)(
      request.buildAwsValue()
    ).map(zio.aws.kafka.model.DescribeConfigurationRevisionResponse.wrap)
      .provideEnvironment(r)
    def updateBrokerStorage(
        request: zio.aws.kafka.model.UpdateBrokerStorageRequest
    ): IO[AwsError, zio.aws.kafka.model.UpdateBrokerStorageResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateBrokerStorageRequest,
        UpdateBrokerStorageResponse
      ]("updateBrokerStorage", api.updateBrokerStorage)(request.buildAwsValue())
        .map(zio.aws.kafka.model.UpdateBrokerStorageResponse.wrap)
        .provideEnvironment(r)
    def listKafkaVersions(
        request: zio.aws.kafka.model.ListKafkaVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.kafka.model.KafkaVersion.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListKafkaVersionsRequest,
        ListKafkaVersionsResponse,
        KafkaVersion
      ](
        "listKafkaVersions",
        api.listKafkaVersions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.kafkaVersions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kafka.model.KafkaVersion.wrap(item))
        .provideEnvironment(r)
    def listKafkaVersionsPaginated(
        request: zio.aws.kafka.model.ListKafkaVersionsRequest
    ): IO[AwsError, zio.aws.kafka.model.ListKafkaVersionsResponse.ReadOnly] =
      asyncRequestResponse[ListKafkaVersionsRequest, ListKafkaVersionsResponse](
        "listKafkaVersions",
        api.listKafkaVersions
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.ListKafkaVersionsResponse.wrap)
        .provideEnvironment(r)
    def listConfigurationRevisions(
        request: zio.aws.kafka.model.ListConfigurationRevisionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kafka.model.ConfigurationRevision.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListConfigurationRevisionsRequest,
      ListConfigurationRevisionsResponse,
      ConfigurationRevision
    ](
      "listConfigurationRevisions",
      api.listConfigurationRevisions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.revisions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.kafka.model.ConfigurationRevision.wrap(item))
      .provideEnvironment(r)
    def listConfigurationRevisionsPaginated(
        request: zio.aws.kafka.model.ListConfigurationRevisionsRequest
    ): IO[
      AwsError,
      zio.aws.kafka.model.ListConfigurationRevisionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListConfigurationRevisionsRequest,
      ListConfigurationRevisionsResponse
    ]("listConfigurationRevisions", api.listConfigurationRevisions)(
      request.buildAwsValue()
    ).map(zio.aws.kafka.model.ListConfigurationRevisionsResponse.wrap)
      .provideEnvironment(r)
    def updateMonitoring(
        request: zio.aws.kafka.model.UpdateMonitoringRequest
    ): IO[AwsError, zio.aws.kafka.model.UpdateMonitoringResponse.ReadOnly] =
      asyncRequestResponse[UpdateMonitoringRequest, UpdateMonitoringResponse](
        "updateMonitoring",
        api.updateMonitoring
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.UpdateMonitoringResponse.wrap)
        .provideEnvironment(r)
    def listNodes(
        request: zio.aws.kafka.model.ListNodesRequest
    ): ZStream[Any, AwsError, zio.aws.kafka.model.NodeInfo.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListNodesRequest,
        ListNodesResponse,
        NodeInfo
      ](
        "listNodes",
        api.listNodes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.nodeInfoList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kafka.model.NodeInfo.wrap(item))
        .provideEnvironment(r)
    def listNodesPaginated(
        request: zio.aws.kafka.model.ListNodesRequest
    ): IO[AwsError, zio.aws.kafka.model.ListNodesResponse.ReadOnly] =
      asyncRequestResponse[ListNodesRequest, ListNodesResponse](
        "listNodes",
        api.listNodes
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.ListNodesResponse.wrap)
        .provideEnvironment(r)
    def listClustersV2(
        request: zio.aws.kafka.model.ListClustersV2Request
    ): ZStream[Any, AwsError, zio.aws.kafka.model.Cluster.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListClustersV2Request,
        ListClustersV2Response,
        Cluster
      ](
        "listClustersV2",
        api.listClustersV2,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.clusterInfoList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kafka.model.Cluster.wrap(item))
        .provideEnvironment(r)
    def listClustersV2Paginated(
        request: zio.aws.kafka.model.ListClustersV2Request
    ): IO[AwsError, zio.aws.kafka.model.ListClustersV2Response.ReadOnly] =
      asyncRequestResponse[ListClustersV2Request, ListClustersV2Response](
        "listClustersV2",
        api.listClustersV2
      )(request.buildAwsValue())
        .map(zio.aws.kafka.model.ListClustersV2Response.wrap)
        .provideEnvironment(r)
  }
  def describeClusterV2(
      request: zio.aws.kafka.model.DescribeClusterV2Request
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.DescribeClusterV2Response.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClusterV2(request))
  def deleteConfiguration(
      request: zio.aws.kafka.model.DeleteConfigurationRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.DeleteConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConfiguration(request))
  def batchDisassociateScramSecret(
      request: zio.aws.kafka.model.BatchDisassociateScramSecretRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.BatchDisassociateScramSecretResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDisassociateScramSecret(request))
  def createConfiguration(
      request: zio.aws.kafka.model.CreateConfigurationRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.CreateConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConfiguration(request))
  def batchAssociateScramSecret(
      request: zio.aws.kafka.model.BatchAssociateScramSecretRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.BatchAssociateScramSecretResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchAssociateScramSecret(request))
  def updateConfiguration(
      request: zio.aws.kafka.model.UpdateConfigurationRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.UpdateConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConfiguration(request))
  def rebootBroker(request: zio.aws.kafka.model.RebootBrokerRequest): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.RebootBrokerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootBroker(request))
  def updateSecurity(request: zio.aws.kafka.model.UpdateSecurityRequest): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.UpdateSecurityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSecurity(request))
  def getBootstrapBrokers(
      request: zio.aws.kafka.model.GetBootstrapBrokersRequest
  ): ZIO[zio.aws.kafka.Kafka, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getBootstrapBrokers(request))
  def createCluster(request: zio.aws.kafka.model.CreateClusterRequest): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.CreateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCluster(request))
  def deleteCluster(request: zio.aws.kafka.model.DeleteClusterRequest): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.DeleteClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCluster(request))
  def listClusterOperations(
      request: zio.aws.kafka.model.ListClusterOperationsRequest
  ): ZStream[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ClusterOperationInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listClusterOperations(request))
  def listClusterOperationsPaginated(
      request: zio.aws.kafka.model.ListClusterOperationsRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ListClusterOperationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClusterOperationsPaginated(request))
  def updateBrokerType(
      request: zio.aws.kafka.model.UpdateBrokerTypeRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.UpdateBrokerTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBrokerType(request))
  def describeClusterOperation(
      request: zio.aws.kafka.model.DescribeClusterOperationRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.DescribeClusterOperationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClusterOperation(request))
  def listConfigurations(
      request: zio.aws.kafka.model.ListConfigurationsRequest
  ): ZStream[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.Configuration.ReadOnly
  ] = ZStream.serviceWithStream(_.listConfigurations(request))
  def listConfigurationsPaginated(
      request: zio.aws.kafka.model.ListConfigurationsRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ListConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConfigurationsPaginated(request))
  def createClusterV2(request: zio.aws.kafka.model.CreateClusterV2Request): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.CreateClusterV2Response.ReadOnly
  ] = ZIO.serviceWithZIO(_.createClusterV2(request))
  def listScramSecrets(
      request: zio.aws.kafka.model.ListScramSecretsRequest
  ): ZStream[zio.aws.kafka.Kafka, AwsError, __string] =
    ZStream.serviceWithStream(_.listScramSecrets(request))
  def listScramSecretsPaginated(
      request: zio.aws.kafka.model.ListScramSecretsRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ListScramSecretsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listScramSecretsPaginated(request))
  def untagResource(
      request: zio.aws.kafka.model.UntagResourceRequest
  ): ZIO[zio.aws.kafka.Kafka, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def updateClusterKafkaVersion(
      request: zio.aws.kafka.model.UpdateClusterKafkaVersionRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.UpdateClusterKafkaVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateClusterKafkaVersion(request))
  def describeConfiguration(
      request: zio.aws.kafka.model.DescribeConfigurationRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.DescribeConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConfiguration(request))
  def describeCluster(request: zio.aws.kafka.model.DescribeClusterRequest): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.DescribeClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCluster(request))
  def listTagsForResource(
      request: zio.aws.kafka.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listClusters(request: zio.aws.kafka.model.ListClustersRequest): ZStream[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ClusterInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listClusters(request))
  def listClustersPaginated(
      request: zio.aws.kafka.model.ListClustersRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ListClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClustersPaginated(request))
  def tagResource(
      request: zio.aws.kafka.model.TagResourceRequest
  ): ZIO[zio.aws.kafka.Kafka, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def getCompatibleKafkaVersions(
      request: zio.aws.kafka.model.GetCompatibleKafkaVersionsRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCompatibleKafkaVersions(request))
  def updateClusterConfiguration(
      request: zio.aws.kafka.model.UpdateClusterConfigurationRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.UpdateClusterConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateClusterConfiguration(request))
  def updateConnectivity(
      request: zio.aws.kafka.model.UpdateConnectivityRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.UpdateConnectivityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConnectivity(request))
  def updateBrokerCount(
      request: zio.aws.kafka.model.UpdateBrokerCountRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.UpdateBrokerCountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBrokerCount(request))
  def describeConfigurationRevision(
      request: zio.aws.kafka.model.DescribeConfigurationRevisionRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.DescribeConfigurationRevisionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConfigurationRevision(request))
  def updateBrokerStorage(
      request: zio.aws.kafka.model.UpdateBrokerStorageRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.UpdateBrokerStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBrokerStorage(request))
  def listKafkaVersions(
      request: zio.aws.kafka.model.ListKafkaVersionsRequest
  ): ZStream[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.KafkaVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.listKafkaVersions(request))
  def listKafkaVersionsPaginated(
      request: zio.aws.kafka.model.ListKafkaVersionsRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ListKafkaVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKafkaVersionsPaginated(request))
  def listConfigurationRevisions(
      request: zio.aws.kafka.model.ListConfigurationRevisionsRequest
  ): ZStream[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ConfigurationRevision.ReadOnly
  ] = ZStream.serviceWithStream(_.listConfigurationRevisions(request))
  def listConfigurationRevisionsPaginated(
      request: zio.aws.kafka.model.ListConfigurationRevisionsRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ListConfigurationRevisionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConfigurationRevisionsPaginated(request))
  def updateMonitoring(
      request: zio.aws.kafka.model.UpdateMonitoringRequest
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.UpdateMonitoringResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMonitoring(request))
  def listNodes(request: zio.aws.kafka.model.ListNodesRequest): ZStream[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.NodeInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listNodes(request))
  def listNodesPaginated(request: zio.aws.kafka.model.ListNodesRequest): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ListNodesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNodesPaginated(request))
  def listClustersV2(
      request: zio.aws.kafka.model.ListClustersV2Request
  ): ZStream[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.Cluster.ReadOnly
  ] = ZStream.serviceWithStream(_.listClustersV2(request))
  def listClustersV2Paginated(
      request: zio.aws.kafka.model.ListClustersV2Request
  ): ZIO[
    zio.aws.kafka.Kafka,
    AwsError,
    zio.aws.kafka.model.ListClustersV2Response.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClustersV2Paginated(request))
}
