package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ClusterOperationInfo(
    clientRequestId: Option[__string] = None,
    clusterArn: Option[__string] = None,
    creationTime: Option[__timestampIso8601] = None,
    endTime: Option[__timestampIso8601] = None,
    errorInfo: Option[zio.aws.kafka.model.ErrorInfo] = None,
    operationArn: Option[__string] = None,
    operationState: Option[__string] = None,
    operationSteps: Option[Iterable[zio.aws.kafka.model.ClusterOperationStep]] =
      None,
    operationType: Option[__string] = None,
    sourceClusterInfo: Option[zio.aws.kafka.model.MutableClusterInfo] = None,
    targetClusterInfo: Option[zio.aws.kafka.model.MutableClusterInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClusterOperationInfo = {
    import ClusterOperationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClusterOperationInfo
      .builder()
      .optionallyWith(clientRequestId.map(value => value: java.lang.String))(
        _.clientRequestId
      )
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(endTime.map(value => value: Instant))(_.endTime)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .optionallyWith(operationArn.map(value => value: java.lang.String))(
        _.operationArn
      )
      .optionallyWith(operationState.map(value => value: java.lang.String))(
        _.operationState
      )
      .optionallyWith(
        operationSteps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operationSteps)
      .optionallyWith(operationType.map(value => value: java.lang.String))(
        _.operationType
      )
      .optionallyWith(sourceClusterInfo.map(value => value.buildAwsValue()))(
        _.sourceClusterInfo
      )
      .optionallyWith(targetClusterInfo.map(value => value.buildAwsValue()))(
        _.targetClusterInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClusterOperationInfo.ReadOnly =
    zio.aws.kafka.model.ClusterOperationInfo.wrap(buildAwsValue())
}
object ClusterOperationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ClusterOperationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClusterOperationInfo =
      zio.aws.kafka.model.ClusterOperationInfo(
        clientRequestId.map(value => value),
        clusterArn.map(value => value),
        creationTime.map(value => value),
        endTime.map(value => value),
        errorInfo.map(value => value.asEditable),
        operationArn.map(value => value),
        operationState.map(value => value),
        operationSteps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        operationType.map(value => value),
        sourceClusterInfo.map(value => value.asEditable),
        targetClusterInfo.map(value => value.asEditable)
      )
    def clientRequestId: Option[__string]
    def clusterArn: Option[__string]
    def creationTime: Option[__timestampIso8601]
    def endTime: Option[__timestampIso8601]
    def errorInfo: Option[zio.aws.kafka.model.ErrorInfo.ReadOnly]
    def operationArn: Option[__string]
    def operationState: Option[__string]
    def operationSteps
        : Option[List[zio.aws.kafka.model.ClusterOperationStep.ReadOnly]]
    def operationType: Option[__string]
    def sourceClusterInfo
        : Option[zio.aws.kafka.model.MutableClusterInfo.ReadOnly]
    def targetClusterInfo
        : Option[zio.aws.kafka.model.MutableClusterInfo.ReadOnly]
    def getClientRequestId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientRequestId", clientRequestId)
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEndTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getErrorInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ErrorInfo.ReadOnly] =
      AwsError.unwrapOptionField("errorInfo", errorInfo)
    def getOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationArn", operationArn)
    def getOperationState: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationState", operationState)
    def getOperationSteps: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ClusterOperationStep.ReadOnly
    ]] = AwsError.unwrapOptionField("operationSteps", operationSteps)
    def getOperationType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operationType", operationType)
    def getSourceClusterInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.MutableClusterInfo.ReadOnly] =
      AwsError.unwrapOptionField("sourceClusterInfo", sourceClusterInfo)
    def getTargetClusterInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.MutableClusterInfo.ReadOnly] =
      AwsError.unwrapOptionField("targetClusterInfo", targetClusterInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationInfo
  ) extends zio.aws.kafka.model.ClusterOperationInfo.ReadOnly {
    override val clientRequestId: Option[__string] =
      scala.Option(impl.clientRequestId()).map(value => value: __string)
    override val clusterArn: Option[__string] =
      scala.Option(impl.clusterArn()).map(value => value: __string)
    override val creationTime: Option[__timestampIso8601] =
      scala.Option(impl.creationTime()).map(value => value: __timestampIso8601)
    override val endTime: Option[__timestampIso8601] =
      scala.Option(impl.endTime()).map(value => value: __timestampIso8601)
    override val errorInfo: Option[zio.aws.kafka.model.ErrorInfo.ReadOnly] =
      scala
        .Option(impl.errorInfo())
        .map(value => zio.aws.kafka.model.ErrorInfo.wrap(value))
    override val operationArn: Option[__string] =
      scala.Option(impl.operationArn()).map(value => value: __string)
    override val operationState: Option[__string] =
      scala.Option(impl.operationState()).map(value => value: __string)
    override val operationSteps
        : Option[List[zio.aws.kafka.model.ClusterOperationStep.ReadOnly]] =
      scala
        .Option(impl.operationSteps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.ClusterOperationStep.wrap(item)
          }.toList
        )
    override val operationType: Option[__string] =
      scala.Option(impl.operationType()).map(value => value: __string)
    override val sourceClusterInfo
        : Option[zio.aws.kafka.model.MutableClusterInfo.ReadOnly] = scala
      .Option(impl.sourceClusterInfo())
      .map(value => zio.aws.kafka.model.MutableClusterInfo.wrap(value))
    override val targetClusterInfo
        : Option[zio.aws.kafka.model.MutableClusterInfo.ReadOnly] = scala
      .Option(impl.targetClusterInfo())
      .map(value => zio.aws.kafka.model.MutableClusterInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationInfo
  ): zio.aws.kafka.model.ClusterOperationInfo.ReadOnly = new Wrapper(impl)
}
