package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ErrorInfo(
    errorCode: Option[__string] = None,
    errorString: Option[__string] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.ErrorInfo = {
    import ErrorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ErrorInfo
      .builder()
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorString.map(value => value: java.lang.String))(
        _.errorString
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ErrorInfo.ReadOnly =
    zio.aws.kafka.model.ErrorInfo.wrap(buildAwsValue())
}
object ErrorInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.ErrorInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ErrorInfo = zio.aws.kafka.model
      .ErrorInfo(errorCode.map(value => value), errorString.map(value => value))
    def errorCode: Option[__string]
    def errorString: Option[__string]
    def getErrorCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorString: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorString", errorString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ErrorInfo
  ) extends zio.aws.kafka.model.ErrorInfo.ReadOnly {
    override val errorCode: Option[__string] =
      scala.Option(impl.errorCode()).map(value => value: __string)
    override val errorString: Option[__string] =
      scala.Option(impl.errorString()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ErrorInfo
  ): zio.aws.kafka.model.ErrorInfo.ReadOnly = new Wrapper(impl)
}
