package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{__integerMin1Max15, __stringMin1Max128}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProvisionedRequest(
    brokerNodeGroupInfo: zio.aws.kafka.model.BrokerNodeGroupInfo,
    clientAuthentication: Option[zio.aws.kafka.model.ClientAuthentication] =
      None,
    configurationInfo: Option[zio.aws.kafka.model.ConfigurationInfo] = None,
    encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo] = None,
    enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring] = None,
    openMonitoring: Option[zio.aws.kafka.model.OpenMonitoringInfo] = None,
    kafkaVersion: __stringMin1Max128,
    loggingInfo: Option[zio.aws.kafka.model.LoggingInfo] = None,
    numberOfBrokerNodes: __integerMin1Max15
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ProvisionedRequest = {
    import ProvisionedRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ProvisionedRequest
      .builder()
      .brokerNodeGroupInfo(brokerNodeGroupInfo.buildAwsValue())
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .optionallyWith(configurationInfo.map(value => value.buildAwsValue()))(
        _.configurationInfo
      )
      .optionallyWith(encryptionInfo.map(value => value.buildAwsValue()))(
        _.encryptionInfo
      )
      .optionallyWith(enhancedMonitoring.map(value => value.unwrap))(
        _.enhancedMonitoring
      )
      .optionallyWith(openMonitoring.map(value => value.buildAwsValue()))(
        _.openMonitoring
      )
      .kafkaVersion(kafkaVersion: java.lang.String)
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .numberOfBrokerNodes(numberOfBrokerNodes: Integer)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ProvisionedRequest.ReadOnly =
    zio.aws.kafka.model.ProvisionedRequest.wrap(buildAwsValue())
}
object ProvisionedRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ProvisionedRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ProvisionedRequest =
      zio.aws.kafka.model.ProvisionedRequest(
        brokerNodeGroupInfo.asEditable,
        clientAuthentication.map(value => value.asEditable),
        configurationInfo.map(value => value.asEditable),
        encryptionInfo.map(value => value.asEditable),
        enhancedMonitoring.map(value => value),
        openMonitoring.map(value => value.asEditable),
        kafkaVersion,
        loggingInfo.map(value => value.asEditable),
        numberOfBrokerNodes
      )
    def brokerNodeGroupInfo: zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly
    def clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly]
    def configurationInfo
        : Option[zio.aws.kafka.model.ConfigurationInfo.ReadOnly]
    def encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly]
    def enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring]
    def openMonitoring: Option[zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly]
    def kafkaVersion: __stringMin1Max128
    def loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly]
    def numberOfBrokerNodes: __integerMin1Max15
    def getBrokerNodeGroupInfo
        : ZIO[Any, Nothing, zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly] =
      ZIO.succeed(brokerNodeGroupInfo)
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
    def getConfigurationInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ConfigurationInfo.ReadOnly] =
      AwsError.unwrapOptionField("configurationInfo", configurationInfo)
    def getEncryptionInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      AwsError.unwrapOptionField("encryptionInfo", encryptionInfo)
    def getEnhancedMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.EnhancedMonitoring] =
      AwsError.unwrapOptionField("enhancedMonitoring", enhancedMonitoring)
    def getOpenMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly] =
      AwsError.unwrapOptionField("openMonitoring", openMonitoring)
    def getKafkaVersion: ZIO[Any, Nothing, __stringMin1Max128] =
      ZIO.succeed(kafkaVersion)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getNumberOfBrokerNodes: ZIO[Any, Nothing, __integerMin1Max15] =
      ZIO.succeed(numberOfBrokerNodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ProvisionedRequest
  ) extends zio.aws.kafka.model.ProvisionedRequest.ReadOnly {
    override val brokerNodeGroupInfo
        : zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly =
      zio.aws.kafka.model.BrokerNodeGroupInfo.wrap(impl.brokerNodeGroupInfo())
    override val clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly] = scala
      .Option(impl.clientAuthentication())
      .map(value => zio.aws.kafka.model.ClientAuthentication.wrap(value))
    override val configurationInfo
        : Option[zio.aws.kafka.model.ConfigurationInfo.ReadOnly] = scala
      .Option(impl.configurationInfo())
      .map(value => zio.aws.kafka.model.ConfigurationInfo.wrap(value))
    override val encryptionInfo
        : Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly] = scala
      .Option(impl.encryptionInfo())
      .map(value => zio.aws.kafka.model.EncryptionInfo.wrap(value))
    override val enhancedMonitoring
        : Option[zio.aws.kafka.model.EnhancedMonitoring] = scala
      .Option(impl.enhancedMonitoring())
      .map(value => zio.aws.kafka.model.EnhancedMonitoring.wrap(value))
    override val openMonitoring
        : Option[zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly] = scala
      .Option(impl.openMonitoring())
      .map(value => zio.aws.kafka.model.OpenMonitoringInfo.wrap(value))
    override val kafkaVersion: __stringMin1Max128 =
      impl.kafkaVersion(): __stringMin1Max128
    override val loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      scala
        .Option(impl.loggingInfo())
        .map(value => zio.aws.kafka.model.LoggingInfo.wrap(value))
    override val numberOfBrokerNodes: __integerMin1Max15 =
      impl.numberOfBrokerNodes(): __integerMin1Max15
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ProvisionedRequest
  ): zio.aws.kafka.model.ProvisionedRequest.ReadOnly = new Wrapper(impl)
}
