package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{MaxResults, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListConfigurationRevisionsRequest(
    arn: __string,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest = {
    import ListConfigurationRevisionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest
      .builder()
      .arn(arn: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.ListConfigurationRevisionsRequest.ReadOnly =
    zio.aws.kafka.model.ListConfigurationRevisionsRequest.wrap(buildAwsValue())
}
object ListConfigurationRevisionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListConfigurationRevisionsRequest =
      zio.aws.kafka.model.ListConfigurationRevisionsRequest(
        arn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def arn: __string
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest
  ) extends zio.aws.kafka.model.ListConfigurationRevisionsRequest.ReadOnly {
    override val arn: __string = impl.arn(): __string
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.kafka.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest
  ): zio.aws.kafka.model.ListConfigurationRevisionsRequest.ReadOnly =
    new Wrapper(impl)
}
