package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{
  __string,
  __integerMin1Max15,
  __stringMin1Max128,
  __stringMin1Max64
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterRequest(
    brokerNodeGroupInfo: zio.aws.kafka.model.BrokerNodeGroupInfo,
    clientAuthentication: Option[zio.aws.kafka.model.ClientAuthentication] =
      None,
    clusterName: __stringMin1Max64,
    configurationInfo: Option[zio.aws.kafka.model.ConfigurationInfo] = None,
    encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo] = None,
    enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring] = None,
    openMonitoring: Option[zio.aws.kafka.model.OpenMonitoringInfo] = None,
    kafkaVersion: __stringMin1Max128,
    loggingInfo: Option[zio.aws.kafka.model.LoggingInfo] = None,
    numberOfBrokerNodes: __integerMin1Max15,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateClusterRequest
      .builder()
      .brokerNodeGroupInfo(brokerNodeGroupInfo.buildAwsValue())
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .clusterName(clusterName: java.lang.String)
      .optionallyWith(configurationInfo.map(value => value.buildAwsValue()))(
        _.configurationInfo
      )
      .optionallyWith(encryptionInfo.map(value => value.buildAwsValue()))(
        _.encryptionInfo
      )
      .optionallyWith(enhancedMonitoring.map(value => value.unwrap))(
        _.enhancedMonitoring
      )
      .optionallyWith(openMonitoring.map(value => value.buildAwsValue()))(
        _.openMonitoring
      )
      .kafkaVersion(kafkaVersion: java.lang.String)
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .numberOfBrokerNodes(numberOfBrokerNodes: Integer)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateClusterRequest.ReadOnly =
    zio.aws.kafka.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateClusterRequest =
      zio.aws.kafka.model.CreateClusterRequest(
        brokerNodeGroupInfo.asEditable,
        clientAuthentication.map(value => value.asEditable),
        clusterName,
        configurationInfo.map(value => value.asEditable),
        encryptionInfo.map(value => value.asEditable),
        enhancedMonitoring.map(value => value),
        openMonitoring.map(value => value.asEditable),
        kafkaVersion,
        loggingInfo.map(value => value.asEditable),
        numberOfBrokerNodes,
        tags.map(value => value)
      )
    def brokerNodeGroupInfo: zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly
    def clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly]
    def clusterName: __stringMin1Max64
    def configurationInfo
        : Option[zio.aws.kafka.model.ConfigurationInfo.ReadOnly]
    def encryptionInfo: Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly]
    def enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring]
    def openMonitoring: Option[zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly]
    def kafkaVersion: __stringMin1Max128
    def loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly]
    def numberOfBrokerNodes: __integerMin1Max15
    def tags: Option[Map[__string, __string]]
    def getBrokerNodeGroupInfo
        : ZIO[Any, Nothing, zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly] =
      ZIO.succeed(brokerNodeGroupInfo)
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
    def getClusterName: ZIO[Any, Nothing, __stringMin1Max64] =
      ZIO.succeed(clusterName)
    def getConfigurationInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ConfigurationInfo.ReadOnly] =
      AwsError.unwrapOptionField("configurationInfo", configurationInfo)
    def getEncryptionInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      AwsError.unwrapOptionField("encryptionInfo", encryptionInfo)
    def getEnhancedMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.EnhancedMonitoring] =
      AwsError.unwrapOptionField("enhancedMonitoring", enhancedMonitoring)
    def getOpenMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly] =
      AwsError.unwrapOptionField("openMonitoring", openMonitoring)
    def getKafkaVersion: ZIO[Any, Nothing, __stringMin1Max128] =
      ZIO.succeed(kafkaVersion)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getNumberOfBrokerNodes: ZIO[Any, Nothing, __integerMin1Max15] =
      ZIO.succeed(numberOfBrokerNodes)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterRequest
  ) extends zio.aws.kafka.model.CreateClusterRequest.ReadOnly {
    override val brokerNodeGroupInfo
        : zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly =
      zio.aws.kafka.model.BrokerNodeGroupInfo.wrap(impl.brokerNodeGroupInfo())
    override val clientAuthentication
        : Option[zio.aws.kafka.model.ClientAuthentication.ReadOnly] = scala
      .Option(impl.clientAuthentication())
      .map(value => zio.aws.kafka.model.ClientAuthentication.wrap(value))
    override val clusterName: __stringMin1Max64 =
      impl.clusterName(): __stringMin1Max64
    override val configurationInfo
        : Option[zio.aws.kafka.model.ConfigurationInfo.ReadOnly] = scala
      .Option(impl.configurationInfo())
      .map(value => zio.aws.kafka.model.ConfigurationInfo.wrap(value))
    override val encryptionInfo
        : Option[zio.aws.kafka.model.EncryptionInfo.ReadOnly] = scala
      .Option(impl.encryptionInfo())
      .map(value => zio.aws.kafka.model.EncryptionInfo.wrap(value))
    override val enhancedMonitoring
        : Option[zio.aws.kafka.model.EnhancedMonitoring] = scala
      .Option(impl.enhancedMonitoring())
      .map(value => zio.aws.kafka.model.EnhancedMonitoring.wrap(value))
    override val openMonitoring
        : Option[zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly] = scala
      .Option(impl.openMonitoring())
      .map(value => zio.aws.kafka.model.OpenMonitoringInfo.wrap(value))
    override val kafkaVersion: __stringMin1Max128 =
      impl.kafkaVersion(): __stringMin1Max128
    override val loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      scala
        .Option(impl.loggingInfo())
        .map(value => zio.aws.kafka.model.LoggingInfo.wrap(value))
    override val numberOfBrokerNodes: __integerMin1Max15 =
      impl.numberOfBrokerNodes(): __integerMin1Max15
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterRequest
  ): zio.aws.kafka.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
