package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClusterOperationResponse(
    clusterOperationInfo: Option[zio.aws.kafka.model.ClusterOperationInfo] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse = {
    import DescribeClusterOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse
      .builder()
      .optionallyWith(clusterOperationInfo.map(value => value.buildAwsValue()))(
        _.clusterOperationInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.DescribeClusterOperationResponse.ReadOnly =
    zio.aws.kafka.model.DescribeClusterOperationResponse.wrap(buildAwsValue())
}
object DescribeClusterOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DescribeClusterOperationResponse =
      zio.aws.kafka.model.DescribeClusterOperationResponse(
        clusterOperationInfo.map(value => value.asEditable)
      )
    def clusterOperationInfo
        : Option[zio.aws.kafka.model.ClusterOperationInfo.ReadOnly]
    def getClusterOperationInfo: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClusterOperationInfo.ReadOnly
    ] = AwsError.unwrapOptionField("clusterOperationInfo", clusterOperationInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse
  ) extends zio.aws.kafka.model.DescribeClusterOperationResponse.ReadOnly {
    override val clusterOperationInfo
        : Option[zio.aws.kafka.model.ClusterOperationInfo.ReadOnly] = scala
      .Option(impl.clusterOperationInfo())
      .map(value => zio.aws.kafka.model.ClusterOperationInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse
  ): zio.aws.kafka.model.DescribeClusterOperationResponse.ReadOnly =
    new Wrapper(impl)
}
