package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClusterOperationStep(
    stepInfo: Option[zio.aws.kafka.model.ClusterOperationStepInfo] = None,
    stepName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClusterOperationStep = {
    import ClusterOperationStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClusterOperationStep
      .builder()
      .optionallyWith(stepInfo.map(value => value.buildAwsValue()))(_.stepInfo)
      .optionallyWith(stepName.map(value => value: java.lang.String))(
        _.stepName
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClusterOperationStep.ReadOnly =
    zio.aws.kafka.model.ClusterOperationStep.wrap(buildAwsValue())
}
object ClusterOperationStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ClusterOperationStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClusterOperationStep =
      zio.aws.kafka.model.ClusterOperationStep(
        stepInfo.map(value => value.asEditable),
        stepName.map(value => value)
      )
    def stepInfo: Option[zio.aws.kafka.model.ClusterOperationStepInfo.ReadOnly]
    def stepName: Option[__string]
    def getStepInfo: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClusterOperationStepInfo.ReadOnly
    ] = AwsError.unwrapOptionField("stepInfo", stepInfo)
    def getStepName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("stepName", stepName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationStep
  ) extends zio.aws.kafka.model.ClusterOperationStep.ReadOnly {
    override val stepInfo
        : Option[zio.aws.kafka.model.ClusterOperationStepInfo.ReadOnly] = scala
      .Option(impl.stepInfo())
      .map(value => zio.aws.kafka.model.ClusterOperationStepInfo.wrap(value))
    override val stepName: Option[__string] =
      scala.Option(impl.stepName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClusterOperationStep
  ): zio.aws.kafka.model.ClusterOperationStep.ReadOnly = new Wrapper(impl)
}
