package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Cluster(
    activeOperationArn: Option[__string] = None,
    clusterType: Option[zio.aws.kafka.model.ClusterType] = None,
    clusterArn: Option[__string] = None,
    clusterName: Option[__string] = None,
    creationTime: Option[__timestampIso8601] = None,
    currentVersion: Option[__string] = None,
    state: Option[zio.aws.kafka.model.ClusterState] = None,
    stateInfo: Option[zio.aws.kafka.model.StateInfo] = None,
    tags: Option[Map[__string, __string]] = None,
    provisioned: Option[zio.aws.kafka.model.Provisioned] = None,
    serverless: Option[zio.aws.kafka.model.Serverless] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Cluster
      .builder()
      .optionallyWith(activeOperationArn.map(value => value: java.lang.String))(
        _.activeOperationArn
      )
      .optionallyWith(clusterType.map(value => value.unwrap))(_.clusterType)
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateInfo.map(value => value.buildAwsValue()))(
        _.stateInfo
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(provisioned.map(value => value.buildAwsValue()))(
        _.provisioned
      )
      .optionallyWith(serverless.map(value => value.buildAwsValue()))(
        _.serverless
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Cluster.ReadOnly =
    zio.aws.kafka.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Cluster = zio.aws.kafka.model.Cluster(
      activeOperationArn.map(value => value),
      clusterType.map(value => value),
      clusterArn.map(value => value),
      clusterName.map(value => value),
      creationTime.map(value => value),
      currentVersion.map(value => value),
      state.map(value => value),
      stateInfo.map(value => value.asEditable),
      tags.map(value => value),
      provisioned.map(value => value.asEditable),
      serverless.map(value => value.asEditable)
    )
    def activeOperationArn: Option[__string]
    def clusterType: Option[zio.aws.kafka.model.ClusterType]
    def clusterArn: Option[__string]
    def clusterName: Option[__string]
    def creationTime: Option[__timestampIso8601]
    def currentVersion: Option[__string]
    def state: Option[zio.aws.kafka.model.ClusterState]
    def stateInfo: Option[zio.aws.kafka.model.StateInfo.ReadOnly]
    def tags: Option[Map[__string, __string]]
    def provisioned: Option[zio.aws.kafka.model.Provisioned.ReadOnly]
    def serverless: Option[zio.aws.kafka.model.Serverless.ReadOnly]
    def getActiveOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("activeOperationArn", activeOperationArn)
    def getClusterType: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterType] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
    def getStateInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.StateInfo.ReadOnly] =
      AwsError.unwrapOptionField("stateInfo", stateInfo)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProvisioned
        : ZIO[Any, AwsError, zio.aws.kafka.model.Provisioned.ReadOnly] =
      AwsError.unwrapOptionField("provisioned", provisioned)
    def getServerless
        : ZIO[Any, AwsError, zio.aws.kafka.model.Serverless.ReadOnly] =
      AwsError.unwrapOptionField("serverless", serverless)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Cluster
  ) extends zio.aws.kafka.model.Cluster.ReadOnly {
    override val activeOperationArn: Option[__string] =
      scala.Option(impl.activeOperationArn()).map(value => value: __string)
    override val clusterType: Option[zio.aws.kafka.model.ClusterType] = scala
      .Option(impl.clusterType())
      .map(value => zio.aws.kafka.model.ClusterType.wrap(value))
    override val clusterArn: Option[__string] =
      scala.Option(impl.clusterArn()).map(value => value: __string)
    override val clusterName: Option[__string] =
      scala.Option(impl.clusterName()).map(value => value: __string)
    override val creationTime: Option[__timestampIso8601] =
      scala.Option(impl.creationTime()).map(value => value: __timestampIso8601)
    override val currentVersion: Option[__string] =
      scala.Option(impl.currentVersion()).map(value => value: __string)
    override val state: Option[zio.aws.kafka.model.ClusterState] = scala
      .Option(impl.state())
      .map(value => zio.aws.kafka.model.ClusterState.wrap(value))
    override val stateInfo: Option[zio.aws.kafka.model.StateInfo.ReadOnly] =
      scala
        .Option(impl.stateInfo())
        .map(value => zio.aws.kafka.model.StateInfo.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val provisioned: Option[zio.aws.kafka.model.Provisioned.ReadOnly] =
      scala
        .Option(impl.provisioned())
        .map(value => zio.aws.kafka.model.Provisioned.wrap(value))
    override val serverless: Option[zio.aws.kafka.model.Serverless.ReadOnly] =
      scala
        .Option(impl.serverless())
        .map(value => zio.aws.kafka.model.Serverless.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Cluster
  ): zio.aws.kafka.model.Cluster.ReadOnly = new Wrapper(impl)
}
