package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListClusterOperationsResponse(
    clusterOperationInfoList: Option[
      Iterable[zio.aws.kafka.model.ClusterOperationInfo]
    ] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse = {
    import ListClusterOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse
      .builder()
      .optionallyWith(
        clusterOperationInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterOperationInfoList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListClusterOperationsResponse.ReadOnly =
    zio.aws.kafka.model.ListClusterOperationsResponse.wrap(buildAwsValue())
}
object ListClusterOperationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClusterOperationsResponse =
      zio.aws.kafka.model.ListClusterOperationsResponse(
        clusterOperationInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clusterOperationInfoList
        : Option[List[zio.aws.kafka.model.ClusterOperationInfo.ReadOnly]]
    def nextToken: Option[__string]
    def getClusterOperationInfoList: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ClusterOperationInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "clusterOperationInfoList",
      clusterOperationInfoList
    )
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse
  ) extends zio.aws.kafka.model.ListClusterOperationsResponse.ReadOnly {
    override val clusterOperationInfoList
        : Option[List[zio.aws.kafka.model.ClusterOperationInfo.ReadOnly]] =
      scala
        .Option(impl.clusterOperationInfoList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.ClusterOperationInfo.wrap(item)
          }.toList
        )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse
  ): zio.aws.kafka.model.ListClusterOperationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
