package zio.aws.kafka.model
import scala.jdk.CollectionConverters._
sealed trait EnhancedMonitoring {
  def unwrap: software.amazon.awssdk.services.kafka.model.EnhancedMonitoring
}
object EnhancedMonitoring {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.EnhancedMonitoring
  ): zio.aws.kafka.model.EnhancedMonitoring = value match {
    case software.amazon.awssdk.services.kafka.model.EnhancedMonitoring.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.EnhancedMonitoring.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.kafka.model.EnhancedMonitoring.PER_BROKER =>
      val r = PER_BROKER
      r
    case software.amazon.awssdk.services.kafka.model.EnhancedMonitoring.PER_TOPIC_PER_BROKER =>
      val r = PER_TOPIC_PER_BROKER
      r
    case software.amazon.awssdk.services.kafka.model.EnhancedMonitoring.PER_TOPIC_PER_PARTITION =>
      val r = PER_TOPIC_PER_PARTITION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kafka.model.EnhancedMonitoring {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.EnhancedMonitoring =
      software.amazon.awssdk.services.kafka.model.EnhancedMonitoring.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT extends zio.aws.kafka.model.EnhancedMonitoring {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.EnhancedMonitoring =
      software.amazon.awssdk.services.kafka.model.EnhancedMonitoring.DEFAULT
  }
  case object PER_BROKER extends zio.aws.kafka.model.EnhancedMonitoring {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.EnhancedMonitoring =
      software.amazon.awssdk.services.kafka.model.EnhancedMonitoring.PER_BROKER
  }
  case object PER_TOPIC_PER_BROKER
      extends zio.aws.kafka.model.EnhancedMonitoring {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.EnhancedMonitoring =
      software.amazon.awssdk.services.kafka.model.EnhancedMonitoring.PER_TOPIC_PER_BROKER
  }
  case object PER_TOPIC_PER_PARTITION
      extends zio.aws.kafka.model.EnhancedMonitoring {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.EnhancedMonitoring =
      software.amazon.awssdk.services.kafka.model.EnhancedMonitoring.PER_TOPIC_PER_PARTITION
  }
}
