package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterResponse(
    clusterArn: Option[__string] = None,
    clusterName: Option[__string] = None,
    state: Option[zio.aws.kafka.model.ClusterState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateClusterResponse = {
    import CreateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateClusterResponse
      .builder()
      .optionallyWith(
        clusterArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        clusterName.map(value => __string.unwrap(value): java.lang.String)
      )(_.clusterName)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateClusterResponse.ReadOnly =
    zio.aws.kafka.model.CreateClusterResponse.wrap(buildAwsValue())
}
object CreateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateClusterResponse =
      zio.aws.kafka.model.CreateClusterResponse(
        clusterArn.map(value => value),
        clusterName.map(value => value),
        state.map(value => value)
      )
    def clusterArn: Option[__string]
    def clusterName: Option[__string]
    def state: Option[zio.aws.kafka.model.ClusterState]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterResponse
  ) extends zio.aws.kafka.model.CreateClusterResponse.ReadOnly {
    override val clusterArn: Option[__string] = scala
      .Option(impl.clusterArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val clusterName: Option[__string] = scala
      .Option(impl.clusterName())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val state: Option[zio.aws.kafka.model.ClusterState] = scala
      .Option(impl.state())
      .map(value => zio.aws.kafka.model.ClusterState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterResponse
  ): zio.aws.kafka.model.CreateClusterResponse.ReadOnly = new Wrapper(impl)
}
