package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PrometheusInfo(
    jmxExporter: Option[zio.aws.kafka.model.JmxExporterInfo] = None,
    nodeExporter: Option[zio.aws.kafka.model.NodeExporterInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.PrometheusInfo = {
    import PrometheusInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.PrometheusInfo
      .builder()
      .optionallyWith(jmxExporter.map(value => value.buildAwsValue()))(
        _.jmxExporter
      )
      .optionallyWith(nodeExporter.map(value => value.buildAwsValue()))(
        _.nodeExporter
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.PrometheusInfo.ReadOnly =
    zio.aws.kafka.model.PrometheusInfo.wrap(buildAwsValue())
}
object PrometheusInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.PrometheusInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.PrometheusInfo =
      zio.aws.kafka.model.PrometheusInfo(
        jmxExporter.map(value => value.asEditable),
        nodeExporter.map(value => value.asEditable)
      )
    def jmxExporter: Option[zio.aws.kafka.model.JmxExporterInfo.ReadOnly]
    def nodeExporter: Option[zio.aws.kafka.model.NodeExporterInfo.ReadOnly]
    def getJmxExporter
        : ZIO[Any, AwsError, zio.aws.kafka.model.JmxExporterInfo.ReadOnly] =
      AwsError.unwrapOptionField("jmxExporter", jmxExporter)
    def getNodeExporter
        : ZIO[Any, AwsError, zio.aws.kafka.model.NodeExporterInfo.ReadOnly] =
      AwsError.unwrapOptionField("nodeExporter", nodeExporter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.PrometheusInfo
  ) extends zio.aws.kafka.model.PrometheusInfo.ReadOnly {
    override val jmxExporter
        : Option[zio.aws.kafka.model.JmxExporterInfo.ReadOnly] = scala
      .Option(impl.jmxExporter())
      .map(value => zio.aws.kafka.model.JmxExporterInfo.wrap(value))
    override val nodeExporter
        : Option[zio.aws.kafka.model.NodeExporterInfo.ReadOnly] = scala
      .Option(impl.nodeExporter())
      .map(value => zio.aws.kafka.model.NodeExporterInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.PrometheusInfo
  ): zio.aws.kafka.model.PrometheusInfo.ReadOnly = new Wrapper(impl)
}
