package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListClustersV2Response(
    clusterInfoList: Option[Iterable[zio.aws.kafka.model.Cluster]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClustersV2Response = {
    import ListClustersV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClustersV2Response
      .builder()
      .optionallyWith(
        clusterInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterInfoList)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListClustersV2Response.ReadOnly =
    zio.aws.kafka.model.ListClustersV2Response.wrap(buildAwsValue())
}
object ListClustersV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClustersV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClustersV2Response =
      zio.aws.kafka.model.ListClustersV2Response(
        clusterInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clusterInfoList: Option[List[zio.aws.kafka.model.Cluster.ReadOnly]]
    def nextToken: Option[__string]
    def getClusterInfoList
        : ZIO[Any, AwsError, List[zio.aws.kafka.model.Cluster.ReadOnly]] =
      AwsError.unwrapOptionField("clusterInfoList", clusterInfoList)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersV2Response
  ) extends zio.aws.kafka.model.ListClustersV2Response.ReadOnly {
    override val clusterInfoList
        : Option[List[zio.aws.kafka.model.Cluster.ReadOnly]] = scala
      .Option(impl.clusterInfoList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kafka.model.Cluster.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersV2Response
  ): zio.aws.kafka.model.ListClustersV2Response.ReadOnly = new Wrapper(impl)
}
