package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterV2Response(
    clusterArn: Option[__string] = None,
    clusterName: Option[__string] = None,
    state: Option[zio.aws.kafka.model.ClusterState] = None,
    clusterType: Option[zio.aws.kafka.model.ClusterType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateClusterV2Response = {
    import CreateClusterV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateClusterV2Response
      .builder()
      .optionallyWith(
        clusterArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        clusterName.map(value => __string.unwrap(value): java.lang.String)
      )(_.clusterName)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(clusterType.map(value => value.unwrap))(_.clusterType)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateClusterV2Response.ReadOnly =
    zio.aws.kafka.model.CreateClusterV2Response.wrap(buildAwsValue())
}
object CreateClusterV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateClusterV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateClusterV2Response =
      zio.aws.kafka.model.CreateClusterV2Response(
        clusterArn.map(value => value),
        clusterName.map(value => value),
        state.map(value => value),
        clusterType.map(value => value)
      )
    def clusterArn: Option[__string]
    def clusterName: Option[__string]
    def state: Option[zio.aws.kafka.model.ClusterState]
    def clusterType: Option[zio.aws.kafka.model.ClusterType]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
    def getClusterType: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterType] =
      AwsError.unwrapOptionField("clusterType", clusterType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterV2Response
  ) extends zio.aws.kafka.model.CreateClusterV2Response.ReadOnly {
    override val clusterArn: Option[__string] = scala
      .Option(impl.clusterArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val clusterName: Option[__string] = scala
      .Option(impl.clusterName())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val state: Option[zio.aws.kafka.model.ClusterState] = scala
      .Option(impl.state())
      .map(value => zio.aws.kafka.model.ClusterState.wrap(value))
    override val clusterType: Option[zio.aws.kafka.model.ClusterType] = scala
      .Option(impl.clusterType())
      .map(value => zio.aws.kafka.model.ClusterType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterV2Response
  ): zio.aws.kafka.model.CreateClusterV2Response.ReadOnly = new Wrapper(impl)
}
