package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__double, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ZookeeperNodeInfo(
    attachedENIId: Option[__string] = None,
    clientVpcIpAddress: Option[__string] = None,
    endpoints: Option[Iterable[__string]] = None,
    zookeeperId: Option[__double] = None,
    zookeeperVersion: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ZookeeperNodeInfo = {
    import ZookeeperNodeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ZookeeperNodeInfo
      .builder()
      .optionallyWith(
        attachedENIId.map(value => __string.unwrap(value): java.lang.String)
      )(_.attachedENIId)
      .optionallyWith(
        clientVpcIpAddress.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.clientVpcIpAddress)
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.endpoints)
      .optionallyWith(
        zookeeperId.map(value => __double.unwrap(value): java.lang.Double)
      )(_.zookeeperId)
      .optionallyWith(
        zookeeperVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.zookeeperVersion)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly =
    zio.aws.kafka.model.ZookeeperNodeInfo.wrap(buildAwsValue())
}
object ZookeeperNodeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ZookeeperNodeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ZookeeperNodeInfo =
      zio.aws.kafka.model.ZookeeperNodeInfo(
        attachedENIId.map(value => value),
        clientVpcIpAddress.map(value => value),
        endpoints.map(value => value),
        zookeeperId.map(value => value),
        zookeeperVersion.map(value => value)
      )
    def attachedENIId: Option[__string]
    def clientVpcIpAddress: Option[__string]
    def endpoints: Option[List[__string]]
    def zookeeperId: Option[__double]
    def zookeeperVersion: Option[__string]
    def getAttachedENIId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("attachedENIId", attachedENIId)
    def getClientVpcIpAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientVpcIpAddress", clientVpcIpAddress)
    def getEndpoints: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getZookeeperId: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("zookeeperId", zookeeperId)
    def getZookeeperVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("zookeeperVersion", zookeeperVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ZookeeperNodeInfo
  ) extends zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly {
    override val attachedENIId: Option[__string] = scala
      .Option(impl.attachedENIId())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val clientVpcIpAddress: Option[__string] = scala
      .Option(impl.clientVpcIpAddress())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val endpoints: Option[List[__string]] = scala
      .Option(impl.endpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kafka.model.primitives.__string(item)
        }.toList
      )
    override val zookeeperId: Option[__double] = scala
      .Option(impl.zookeeperId())
      .map(value => zio.aws.kafka.model.primitives.__double(value))
    override val zookeeperVersion: Option[__string] = scala
      .Option(impl.zookeeperVersion())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ZookeeperNodeInfo
  ): zio.aws.kafka.model.ZookeeperNodeInfo.ReadOnly = new Wrapper(impl)
}
