package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Serverless(
    vpcConfigs: Iterable[zio.aws.kafka.model.VpcConfig],
    clientAuthentication: Option[
      zio.aws.kafka.model.ServerlessClientAuthentication
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.Serverless = {
    import Serverless.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Serverless
      .builder()
      .vpcConfigs(vpcConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Serverless.ReadOnly =
    zio.aws.kafka.model.Serverless.wrap(buildAwsValue())
}
object Serverless {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.Serverless] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Serverless =
      zio.aws.kafka.model.Serverless(
        vpcConfigs.map { item =>
          item.asEditable
        },
        clientAuthentication.map(value => value.asEditable)
      )
    def vpcConfigs: List[zio.aws.kafka.model.VpcConfig.ReadOnly]
    def clientAuthentication
        : Option[zio.aws.kafka.model.ServerlessClientAuthentication.ReadOnly]
    def getVpcConfigs
        : ZIO[Any, Nothing, List[zio.aws.kafka.model.VpcConfig.ReadOnly]] =
      ZIO.succeed(vpcConfigs)
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ServerlessClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Serverless
  ) extends zio.aws.kafka.model.Serverless.ReadOnly {
    override val vpcConfigs: List[zio.aws.kafka.model.VpcConfig.ReadOnly] = impl
      .vpcConfigs()
      .asScala
      .map { item =>
        zio.aws.kafka.model.VpcConfig.wrap(item)
      }
      .toList
    override val clientAuthentication
        : Option[zio.aws.kafka.model.ServerlessClientAuthentication.ReadOnly] =
      scala
        .Option(impl.clientAuthentication())
        .map(value =>
          zio.aws.kafka.model.ServerlessClientAuthentication.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Serverless
  ): zio.aws.kafka.model.Serverless.ReadOnly = new Wrapper(impl)
}
