package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchDisassociateScramSecretResponse(
    clusterArn: Option[__string] = None,
    unprocessedScramSecrets: Option[
      Iterable[zio.aws.kafka.model.UnprocessedScramSecret]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretResponse = {
    import BatchDisassociateScramSecretResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretResponse
      .builder()
      .optionallyWith(
        clusterArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        unprocessedScramSecrets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedScramSecrets)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.BatchDisassociateScramSecretResponse.ReadOnly =
    zio.aws.kafka.model.BatchDisassociateScramSecretResponse
      .wrap(buildAwsValue())
}
object BatchDisassociateScramSecretResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BatchDisassociateScramSecretResponse =
      zio.aws.kafka.model.BatchDisassociateScramSecretResponse(
        clusterArn.map(value => value),
        unprocessedScramSecrets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterArn: Option[__string]
    def unprocessedScramSecrets
        : Option[List[zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly]]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getUnprocessedScramSecrets: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedScramSecrets",
      unprocessedScramSecrets
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretResponse
  ) extends zio.aws.kafka.model.BatchDisassociateScramSecretResponse.ReadOnly {
    override val clusterArn: Option[__string] = scala
      .Option(impl.clusterArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val unprocessedScramSecrets
        : Option[List[zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly]] =
      scala
        .Option(impl.unprocessedScramSecrets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.UnprocessedScramSecret.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretResponse
  ): zio.aws.kafka.model.BatchDisassociateScramSecretResponse.ReadOnly =
    new Wrapper(impl)
}
