package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RebootBrokerResponse(
    clusterArn: Option[__string] = None,
    clusterOperationArn: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.RebootBrokerResponse = {
    import RebootBrokerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.RebootBrokerResponse
      .builder()
      .optionallyWith(
        clusterArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        clusterOperationArn.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.clusterOperationArn)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.RebootBrokerResponse.ReadOnly =
    zio.aws.kafka.model.RebootBrokerResponse.wrap(buildAwsValue())
}
object RebootBrokerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.RebootBrokerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.RebootBrokerResponse =
      zio.aws.kafka.model.RebootBrokerResponse(
        clusterArn.map(value => value),
        clusterOperationArn.map(value => value)
      )
    def clusterArn: Option[__string]
    def clusterOperationArn: Option[__string]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterOperationArn", clusterOperationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.RebootBrokerResponse
  ) extends zio.aws.kafka.model.RebootBrokerResponse.ReadOnly {
    override val clusterArn: Option[__string] = scala
      .Option(impl.clusterArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val clusterOperationArn: Option[__string] = scala
      .Option(impl.clusterOperationArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.RebootBrokerResponse
  ): zio.aws.kafka.model.RebootBrokerResponse.ReadOnly = new Wrapper(impl)
}
