package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateClusterConfigurationResponse(
    clusterArn: Option[__string] = None,
    clusterOperationArn: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationResponse = {
    import UpdateClusterConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationResponse
      .builder()
      .optionallyWith(
        clusterArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        clusterOperationArn.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.clusterOperationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.UpdateClusterConfigurationResponse.ReadOnly =
    zio.aws.kafka.model.UpdateClusterConfigurationResponse.wrap(buildAwsValue())
}
object UpdateClusterConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateClusterConfigurationResponse =
      zio.aws.kafka.model.UpdateClusterConfigurationResponse(
        clusterArn.map(value => value),
        clusterOperationArn.map(value => value)
      )
    def clusterArn: Option[__string]
    def clusterOperationArn: Option[__string]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterOperationArn", clusterOperationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationResponse
  ) extends zio.aws.kafka.model.UpdateClusterConfigurationResponse.ReadOnly {
    override val clusterArn: Option[__string] = scala
      .Option(impl.clusterArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val clusterOperationArn: Option[__string] = scala
      .Option(impl.clusterOperationArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationResponse
  ): zio.aws.kafka.model.UpdateClusterConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
