package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListConfigurationRevisionsResponse(
    nextToken: Option[__string] = None,
    revisions: Option[Iterable[zio.aws.kafka.model.ConfigurationRevision]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse = {
    import ListConfigurationRevisionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        revisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.revisions)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.ListConfigurationRevisionsResponse.ReadOnly =
    zio.aws.kafka.model.ListConfigurationRevisionsResponse.wrap(buildAwsValue())
}
object ListConfigurationRevisionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListConfigurationRevisionsResponse =
      zio.aws.kafka.model.ListConfigurationRevisionsResponse(
        nextToken.map(value => value),
        revisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[__string]
    def revisions
        : Option[List[zio.aws.kafka.model.ConfigurationRevision.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRevisions: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.ConfigurationRevision.ReadOnly
    ]] = AwsError.unwrapOptionField("revisions", revisions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse
  ) extends zio.aws.kafka.model.ListConfigurationRevisionsResponse.ReadOnly {
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val revisions
        : Option[List[zio.aws.kafka.model.ConfigurationRevision.ReadOnly]] =
      scala
        .Option(impl.revisions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.ConfigurationRevision.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse
  ): zio.aws.kafka.model.ListConfigurationRevisionsResponse.ReadOnly =
    new Wrapper(impl)
}
