package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServerlessRequest(
    vpcConfigs: Iterable[zio.aws.kafka.model.VpcConfig],
    clientAuthentication: Option[
      zio.aws.kafka.model.ServerlessClientAuthentication
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ServerlessRequest = {
    import ServerlessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ServerlessRequest
      .builder()
      .vpcConfigs(vpcConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ServerlessRequest.ReadOnly =
    zio.aws.kafka.model.ServerlessRequest.wrap(buildAwsValue())
}
object ServerlessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ServerlessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ServerlessRequest =
      zio.aws.kafka.model.ServerlessRequest(
        vpcConfigs.map { item =>
          item.asEditable
        },
        clientAuthentication.map(value => value.asEditable)
      )
    def vpcConfigs: List[zio.aws.kafka.model.VpcConfig.ReadOnly]
    def clientAuthentication
        : Option[zio.aws.kafka.model.ServerlessClientAuthentication.ReadOnly]
    def getVpcConfigs
        : ZIO[Any, Nothing, List[zio.aws.kafka.model.VpcConfig.ReadOnly]] =
      ZIO.succeed(vpcConfigs)
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ServerlessClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ServerlessRequest
  ) extends zio.aws.kafka.model.ServerlessRequest.ReadOnly {
    override val vpcConfigs: List[zio.aws.kafka.model.VpcConfig.ReadOnly] = impl
      .vpcConfigs()
      .asScala
      .map { item =>
        zio.aws.kafka.model.VpcConfig.wrap(item)
      }
      .toList
    override val clientAuthentication
        : Option[zio.aws.kafka.model.ServerlessClientAuthentication.ReadOnly] =
      scala
        .Option(impl.clientAuthentication())
        .map(value =>
          zio.aws.kafka.model.ServerlessClientAuthentication.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ServerlessRequest
  ): zio.aws.kafka.model.ServerlessRequest.ReadOnly = new Wrapper(impl)
}
